/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.wrapper.dependencies.common.relay.server.client;

import com.corundumstudio.socketio.SocketIOClient;
import com.gamedash.daemon.wrapper.dependencies.common.relay.server.RelayServer;
import com.gamedash.daemon.wrapper.dependencies.common.relay.server.client.RelayClient;
import com.gamedash.daemon.wrapper.dependencies.common.relay.server.client.RelayClientAlreadyExistsException;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;

public class RelayClients {
    private final RelayServer server;
    private final List<RelayClient> clients = new CopyOnWriteArrayList<RelayClient>();

    public RelayClients(RelayServer server) {
        this.server = server;
    }

    public List<RelayClient> getAll() {
        return this.clients;
    }

    public RelayClient create(SocketIOClient socketIOClient) {
        if (this.exists(socketIOClient.getSessionId())) {
            throw new RelayClientAlreadyExistsException("Client " + socketIOClient.getSessionId().toString() + " already exists");
        }
        RelayClient client = new RelayClient(this.server, socketIOClient);
        this.clients.add(client);
        return client;
    }

    public boolean exists(UUID id) {
        for (RelayClient client : this.getAll()) {
            if (client.getId().compareTo(id) != 0) continue;
            return true;
        }
        return false;
    }

    public RelayClient get(UUID id) {
        for (RelayClient client : this.getAll()) {
            if (client.getId().compareTo(id) != 0) continue;
            return client;
        }
        return null;
    }

    public void remove(UUID id) {
        for (RelayClient client : this.getAll()) {
            if (client.getId().compareTo(id) != 0) continue;
            this.clients.remove(client);
        }
    }
}

