/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.wrapper.dependencies.common.relay.server.client;

import com.gamedash.daemon.wrapper.dependencies.common.relay.server.RelayServer;
import com.gamedash.daemon.wrapper.dependencies.common.relay.server.channel.RelayChannel;
import com.gamedash.daemon.wrapper.dependencies.common.relay.server.client.RelayClient;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class RelayClientChannelDirectory {
    private final RelayServer server;
    private final RelayClient client;

    public RelayClientChannelDirectory(RelayServer server, RelayClient client) {
        this.server = server;
        this.client = client;
    }

    public List<RelayChannel> getAll() {
        ArrayList<RelayChannel> channels = new ArrayList<RelayChannel>();
        this.server.getChannels().getAll().forEach(channel -> {
            if (!channel.getClients().has(this.client.getId())) {
                return;
            }
            channels.add((RelayChannel)channel);
        });
        return channels;
    }

    public boolean exists(String name) {
        for (RelayChannel channel : this.getAll()) {
            if (!channel.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public void remove(String name) {
        Optional<RelayChannel> channel = this.server.getChannels().get(name);
        channel.ifPresent(relayChannel -> relayChannel.getClients().remove(this.client.getId()));
    }
}

