/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.wrapper.dependencies.common.relay.server.channel;

import com.gamedash.daemon.wrapper.dependencies.common.relay.payload.RelayPayload;
import com.gamedash.daemon.wrapper.dependencies.common.relay.server.RelayServer;
import com.gamedash.daemon.wrapper.dependencies.common.relay.server.channel.RelayChannelClientsDirectory;
import com.gamedash.daemon.wrapper.dependencies.common.relay.server.channel.broadcast.ManagedBroadcaster;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelayChannel {
    private static final Logger logger = LoggerFactory.getLogger(RelayChannel.class);
    private final RelayServer server;
    private final String name;
    private final RelayChannelClientsDirectory clientsDirectory;

    public RelayChannel(RelayServer server, String name) {
        this.server = server;
        this.name = name;
        this.clientsDirectory = new RelayChannelClientsDirectory(server, this);
    }

    public String getName() {
        return this.name;
    }

    public RelayChannelClientsDirectory getClients() {
        return this.clientsDirectory;
    }

    public boolean compareName(String name) {
        return this.getName().equalsIgnoreCase(name);
    }

    public void delete() {
        this.server.getChannels().delete(this.getName());
    }

    public void broadcast(RelayPayload<?> payload) throws Exception {
        logger.debug("Broadcasting message \"" + payload.getMessage() + "\" with type " + payload.getType() + " to channel " + this.getName());
        final RelayChannel channel = this;
        ManagedBroadcaster broadcaster = ManagedBroadcaster.create((List<RelayChannel>)new ArrayList<RelayChannel>(){
            {
                this.add(channel);
            }
        });
        broadcaster.broadcast(payload);
    }

    public boolean equals(RelayChannel channel) {
        return this.compareName(channel.getName());
    }
}

