/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.wrapper.dependencies.common.license.system;

import com.gamedash.daemon.wrapper.dependencies.com.google.gson.JsonObject;
import com.gamedash.daemon.wrapper.dependencies.common.license.License;
import com.gamedash.daemon.wrapper.dependencies.common.license.api.client.LicenseApiClient;
import com.gamedash.daemon.wrapper.dependencies.common.license.api.client.LicenseApiClientQuery;
import com.gamedash.daemon.wrapper.dependencies.common.license.api.client.LicenseApiClientQueryResponse;
import com.gamedash.daemon.wrapper.dependencies.common.license.system.LicenseSystem;
import com.gamedash.daemon.wrapper.dependencies.common.license.system.LicenseSystemAlreadyExistsException;
import com.gamedash.daemon.wrapper.dependencies.common.license.system.LicenseSystemMaxExceededException;
import com.gamedash.daemon.wrapper.dependencies.oshi.SystemInfo;

public class LicenseSystems {
    private License license;

    public LicenseSystems(License license) {
        this.license = license;
    }

    public LicenseSystem get(String id) {
        return new LicenseSystem(this.license, id);
    }

    public LicenseSystem getCurrent() {
        return this.get(LicenseSystems.getId());
    }

    public boolean exists(String id) throws Exception {
        LicenseApiClientQuery query = LicenseApiClient.createQuery("license/system");
        query.getParameters().create("hash", this.license.getHash().toString());
        query.getParameters().create("id", id);
        query.setShouldHandleResponse(false);
        LicenseApiClientQueryResponse response = query.get();
        return response.getStatusCode() != 404;
    }

    public void create(String id) throws Exception {
        LicenseApiClientQuery query = LicenseApiClient.createQuery("license/system");
        query.getParameters().create("hash", this.license.getHash().toString());
        query.getParameters().create("id", id);
        query.setShouldHandleResponse(false);
        LicenseApiClientQueryResponse response = query.post();
        if (response.getStatusCode() != 200) {
            JsonObject errorObject = response.getJsonObject().get("error").getAsJsonObject();
            if (errorObject.get("code") != null) {
                if (errorObject.get("code").getAsString().equals("SYSTEM_MAX_EXCEEDED")) {
                    throw new LicenseSystemMaxExceededException("System maximum exceeded");
                }
                if (errorObject.get("code").getAsString().equals("SYSTEM_ALREADY_EXISTS")) {
                    throw new LicenseSystemAlreadyExistsException("System already exists");
                }
            }
            throw new Exception(response.getJsonObject().get("error").getAsJsonObject().get("status").getAsString());
        }
    }

    private static String getId() {
        SystemInfo systemInfo = new SystemInfo();
        String processorId = systemInfo.getHardware().getProcessor().getProcessorIdentifier().getProcessorID();
        return processorId.replaceAll("[^a-zA-Z0-9:]", "");
    }
}

