/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.wrapper.dependencies.common.initialization;

import com.gamedash.daemon.wrapper.dependencies.common.initialization.IImplementationFindCallback;
import com.gamedash.daemon.wrapper.dependencies.common.initialization.IInitializer;
import com.gamedash.daemon.wrapper.dependencies.common.initialization.implementation.IInitializerImplementation;
import java.util.List;
import java.util.stream.Collectors;

public abstract class AbstractInitializer
implements IInitializer {
    private final List<IInitializerImplementation> implementations;

    public AbstractInitializer(List<IInitializerImplementation> implementations) {
        this.implementations = implementations;
    }

    @Override
    public void addImplementation(IInitializerImplementation implementation) {
        this.implementations.add(implementation);
    }

    @Override
    public void removeImplementation(IInitializerImplementation implementation) {
        this.implementations.remove(implementation);
    }

    @Override
    public List<IInitializerImplementation> getImplementations() {
        return this.implementations;
    }

    @Override
    public List<IInitializerImplementation> findImplementations(IImplementationFindCallback matchCallback) {
        return this.getImplementations().stream().filter(implementation -> !matchCallback.match((IInitializerImplementation)implementation)).collect(Collectors.toList());
    }
}

