/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.wrapper.dependencies.common.helpers.fileSystem;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.xml.bind.annotation.adapters.HexBinaryAdapter;

public class FileSystemHelpers {
    public static File getOwnDirectory(Class clazz) {
        try {
            return new File(clazz.getProtectionDomain().getCodeSource().getLocation().toURI()).getParentFile();
        }
        catch (URISyntaxException exception) {
            return null;
        }
    }

    public static String getSHA1Checksum(File file) throws IOException, NoSuchAlgorithmException {
        MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
        try (FileInputStream input = new FileInputStream(file);){
            byte[] buffer = new byte[8192];
            int len = ((InputStream)input).read(buffer);
            while (len != -1) {
                sha1.update(buffer, 0, len);
                len = ((InputStream)input).read(buffer);
            }
            String string = new HexBinaryAdapter().marshal(sha1.digest());
            return string;
        }
    }
}

