/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.wrapper.dependencies.common.dataLayer;

import com.gamedash.daemon.wrapper.dependencies.common.dataLayer.IFetchFunction;
import com.gamedash.daemon.wrapper.dependencies.common.time.Time;
import java.util.List;

public class ValueSource {
    private List<String> fetchableValues;
    private IFetchFunction fetchFunction;
    private Integer timeout;
    private Time timeLastFetched;

    public ValueSource(List<String> fetchableValues, IFetchFunction fetchFunction) {
        this.fetchableValues = fetchableValues;
        this.fetchFunction = fetchFunction;
    }

    public List<String> getFetchableValues() {
        return this.fetchableValues;
    }

    public boolean valueIsFetchable(String name) {
        for (String _name : this.getFetchableValues()) {
            if (!name.equals(_name)) continue;
            return true;
        }
        return false;
    }

    public Object fetch(String name) throws Exception {
        return this.fetchFunction.method(name);
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public boolean hasTimedOut() {
        Integer timeout = this.getTimeout();
        Time timeLastFetched = this.getTimeLastFetched();
        return timeout != null && timeLastFetched != null && Time.now().getTimestamp() - timeLastFetched.getTimestamp() > (long)timeout.intValue();
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public Time getTimeLastFetched() {
        return this.timeLastFetched;
    }

    public void updateTimeLastFetched() {
        this.setTimeLastFetched(Time.now());
    }

    public void setTimeLastFetched(Time time) {
        this.timeLastFetched = time;
    }
}

