/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.wrapper.dependencies.common.dataLayer;

import com.gamedash.daemon.wrapper.dependencies.common.dataLayer.IFetchFunction;
import com.gamedash.daemon.wrapper.dependencies.common.dataLayer.Store;
import com.gamedash.daemon.wrapper.dependencies.common.dataLayer.ValueSource;
import com.gamedash.daemon.wrapper.dependencies.common.dataLayer.ValueSourceNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class AbstractDataLayer {
    public Store store = new Store();
    private List<ValueSource> valueSources = new ArrayList<ValueSource>();

    public List<ValueSource> getValueSources() {
        return this.valueSources;
    }

    public ValueSource registerValueSource(String[] fetchableValues, IFetchFunction fetchFunction) {
        return this.registerValueSource(Arrays.asList(fetchableValues), fetchFunction);
    }

    public ValueSource registerValueSource(List<String> fetchableValues, IFetchFunction fetchFunction) {
        ValueSource valueSource = new ValueSource(fetchableValues, fetchFunction);
        this.valueSources.add(valueSource);
        return valueSource;
    }

    public Object getValue(String name) throws Exception {
        return this.getValue(name, Object.class);
    }

    public synchronized <T> T getValue(String name, Class<? extends T> clazz) throws Exception {
        ValueSource valueSource = this.findValueSource(name);
        if (valueSource != null && valueSource.hasTimedOut()) {
            this.store.clearValueSource(valueSource);
        }
        if (this.store.valueExists(name)) {
            return (T)this.store.getValue(name);
        }
        if (valueSource != null) {
            Object value = valueSource.fetch(name);
            this.store.setValue(name, value);
            return (T)value;
        }
        throw new ValueSourceNotFoundException("Value source that supports getting value " + name + " not found");
    }

    public void setValue(String name, Object value) {
        if (!this.valueIsFetchable(name)) {
            throw new ValueSourceNotFoundException("No sources allow value " + name);
        }
        this.store.setValue(name, value);
    }

    public void clearValue(String name) {
        this.store.deleteValue(name);
    }

    public ValueSource findValueSource(String name) {
        for (ValueSource valueSource : this.getValueSources()) {
            if (!valueSource.valueIsFetchable(name)) continue;
            return valueSource;
        }
        return null;
    }

    public void clear() {
        this.store.clear();
    }

    public boolean valueIsFetchable(String name) {
        return true;
    }

    public Store getStore() {
        return this.store;
    }
}

