/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.wrapper.dependencies.common.config.transformer;

import com.gamedash.daemon.wrapper.dependencies.common.config.transformer.BooleanTransformer;
import com.gamedash.daemon.wrapper.dependencies.common.config.transformer.ITransformer;
import com.gamedash.daemon.wrapper.dependencies.common.config.transformer.IntegerTransformer;
import com.gamedash.daemon.wrapper.dependencies.common.config.transformer.ListTransformer;
import com.gamedash.daemon.wrapper.dependencies.common.config.transformer.StringTransformer;
import java.util.ArrayList;
import java.util.List;

public class Transformers {
    public static final List<ITransformer<?>> transformers = new ArrayList<ITransformer<?>>(){
        {
            this.add(new BooleanTransformer());
            this.add(new IntegerTransformer());
            this.add(new ListTransformer());
            this.add(new StringTransformer());
        }
    };

    public static <T> ITransformer<T> determineTransformerFromType(Class<T> type) {
        for (ITransformer<?> transformer : transformers) {
            if (!transformer.getTypes().contains(type)) continue;
            return transformer;
        }
        return null;
    }
}

