/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.wrapper.dependencies.common.cache;

import com.gamedash.daemon.wrapper.dependencies.common.cache.IImplementation;
import com.gamedash.daemon.wrapper.dependencies.common.utilities.ExpiringValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedValue<T>
implements IImplementation {
    public static final Logger logger = LoggerFactory.getLogger(CachedValue.class);
    private final ExpiringValue<T> value = new ExpiringValue();

    public CachedValue() {
    }

    public CachedValue(T value) {
        if (value != null) {
            this.setValue(value);
        }
    }

    public T getValue() {
        return this.value.getValue();
    }

    public void setValue(T value) {
        this.value.setValue(value);
    }

    @Override
    public boolean isCached() {
        return this.value.getValue() != null;
    }

    public Integer getExpiryThreshold() {
        return this.value.getThreshold();
    }

    public void setExpiryThreshold(Integer seconds) {
        this.value.setThreshold(seconds);
    }

    @Override
    public void clear() {
        this.value.setValue(null);
    }

    public synchronized T handle(ICachedValueFetchCallback<T> callback) throws Exception {
        if (!this.isCached()) {
            this.setValue(callback.method());
        }
        return this.getValue();
    }

    @FunctionalInterface
    public static interface ICachedValueFetchCallback<T> {
        public T method() throws Exception;
    }
}

