/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.wrapper.dependencies.common.authentication;

import com.gamedash.daemon.wrapper.dependencies.common.authentication.AuthenticationException;
import com.gamedash.daemon.wrapper.dependencies.common.authentication.AuthenticationResult;
import com.gamedash.daemon.wrapper.dependencies.common.authentication.token.AuthenticationToken;
import com.gamedash.daemon.wrapper.dependencies.common.config.Config;

public class Authentication {
    public static AuthenticationResult authenticate() throws Exception {
        if (!Authentication.hasCurrentToken()) {
            return AuthenticationResult.create(false, "No authentication token set");
        }
        if (!Authentication.getCurrentToken().validate().isValid()) {
            return AuthenticationResult.create(false, "Authentication token is invalid");
        }
        return AuthenticationResult.create(true);
    }

    public static AuthenticationToken getToken(String token) {
        return new AuthenticationToken(token);
    }

    public static AuthenticationToken getCurrentToken() throws Exception {
        if (!Authentication.hasCurrentToken()) {
            throw new AuthenticationException("No token is set");
        }
        return new AuthenticationToken(Config.getDefaultFile().getValue("authentication.token"));
    }

    public static boolean hasCurrentToken() throws Exception {
        return Config.getDefaultFile().valueExists("authentication.token");
    }

    public static void setCurrentToken(AuthenticationToken token) throws Exception {
        Config.getDefaultFile().setValue("authentication.token", token.toString());
    }
}

