/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.wrapper.dependencies.common.api.server;

import com.gamedash.daemon.wrapper.dependencies.com.google.gson.Gson;
import com.gamedash.daemon.wrapper.dependencies.common.api.server.ApiServerException;
import com.gamedash.daemon.wrapper.dependencies.common.api.server.ApiServerKeyStore;
import com.gamedash.daemon.wrapper.dependencies.common.api.server.BeforeListener;
import com.gamedash.daemon.wrapper.dependencies.common.api.server.IOnBeforeListenerCallback;
import com.gamedash.daemon.wrapper.dependencies.common.api.server.authentication.NotAuthenticatedException;
import com.gamedash.daemon.wrapper.dependencies.common.api.server.exception.ExceptionManager;
import com.gamedash.daemon.wrapper.dependencies.common.api.server.exception.ExceptionSerializer;
import com.gamedash.daemon.wrapper.dependencies.common.api.server.request.Request;
import com.gamedash.daemon.wrapper.dependencies.common.api.server.route.manager.RoutesManager;
import com.gamedash.daemon.wrapper.dependencies.common.development.DevelopmentMode;
import com.gamedash.daemon.wrapper.dependencies.common.listener.ListenerCallbackHandle;
import com.gamedash.daemon.wrapper.dependencies.common.network.Network;
import com.gamedash.daemon.wrapper.dependencies.spark.Response;
import com.gamedash.daemon.wrapper.dependencies.spark.Service;
import java.io.FileNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiServer {
    private static final Logger logger = LoggerFactory.getLogger(ApiServer.class);
    private final Gson gson = new Gson();
    private final RoutesManager routesManager = new RoutesManager(this);
    private final ExceptionManager exceptionManager;
    private final BeforeListener beforeListener = new BeforeListener();
    private Boolean isRunning = false;
    private String ipAddress = Network.getIp().getHostAddress();
    private Service service;
    private Integer port;
    private ApiServerKeyStore keyStore;

    public ApiServer() {
        this.exceptionManager = new ExceptionManager(this);
    }

    public void start() throws Exception {
        if (this.isRunning().booleanValue()) {
            return;
        }
        this.setIsRunning(true);
        try {
            if (this.getPort() == null) {
                throw new ApiServerException("No port is set");
            }
            this.service = Service.ignite();
            this.getService().ipAddress(this.getIpAddress());
            this.getService().port(this.getPort());
            if (this.getKeyStore() != null) {
                ApiServerKeyStore keyStore = this.getKeyStore();
                this.getService().secure(keyStore.getFile().getAbsolutePath(), keyStore.getPassword(), null, null);
                logger.info("TLS enabled");
            }
            this.getExceptionManager().createHandler(Exception.class).register();
            this.getExceptionManager().createHandler(NotAuthenticatedException.class, 403).register();
            this.getExceptionManager().createHandler(FileNotFoundException.class, 404).register();
            this.getService().before((request, response) -> {
                logger.debug(request.ip() + " " + request.requestMethod() + " " + request.uri());
                this.invokeOnBefore(new Request(request), response);
                if (DevelopmentMode.isEnabled()) {
                    logger.debug("Incoming request from " + request.ip() + " for " + request.requestMethod() + " " + request.uri(), (Object)"api.server");
                }
            });
            this.getService().afterAfter((request, response) -> response.header("Server", "GameDash Daemon"));
            this.getService().notFound((request, response) -> {
                response.type("application/json");
                return ExceptionSerializer.serialize(new ApiServerException("Route " + request.uri() + " was not found"));
            });
            this.getService().awaitInitialization();
            logger.info("Listening on port " + this.getPort());
        }
        catch (Exception e) {
            this.setIsRunning(false);
            throw e;
        }
    }

    public void stop() {
        if (this.isRunning().booleanValue()) {
            this.getService().stop();
            this.getService().awaitStop();
        }
    }

    public Boolean isRunning() {
        return this.isRunning;
    }

    public void setIsRunning(Boolean isRunning) {
        this.isRunning = isRunning;
    }

    public Service getService() {
        return this.service;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public Integer getPort() throws Exception {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public ApiServerKeyStore getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(ApiServerKeyStore keyStore) {
        this.keyStore = keyStore;
    }

    public RoutesManager getRoutesManager() {
        return this.routesManager;
    }

    public ExceptionManager getExceptionManager() {
        return this.exceptionManager;
    }

    public ListenerCallbackHandle<IOnBeforeListenerCallback> onBefore(IOnBeforeListenerCallback callback) {
        return this.beforeListener.addCallback(callback);
    }

    public void invokeOnBefore(Request request, Response response) throws Exception {
        this.beforeListener.invoke(request, response);
    }
}

