/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.wrapper.commands.scanner;

import com.gamedash.daemon.wrapper.commands.Command;
import com.gamedash.daemon.wrapper.commands.Commands;
import com.gamedash.daemon.wrapper.commands.scanner.CommandListener;
import com.gamedash.daemon.wrapper.commands.scanner.interpreter.CommandInterpretationResult;
import com.gamedash.daemon.wrapper.commands.scanner.interpreter.CommandInterpreter;
import com.gamedash.daemon.wrapper.dependencies.org.apache.commons.lang3.exception.ExceptionUtils;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandScanner {
    private static final Logger logger = LoggerFactory.getLogger(CommandScanner.class);
    private final BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
    private final CommandListener commandListener = new CommandListener();

    private String readLine() throws Exception {
        String line = this.reader.readLine();
        this.commandListener.invoke(line);
        return line;
    }

    public Thread listen() {
        Thread thread = new Thread(() -> {
            try {
                this.commandListener.addCallback(input -> {
                    try {
                        CommandInterpretationResult result = CommandInterpreter.interpret(input);
                        Command command = Commands.get(result.getName());
                        if (command == null) {
                            logger.error("Command " + result.getName() + " not found");
                            return;
                        }
                        command.run();
                    }
                    finally {
                        this.readLine();
                    }
                });
                this.readLine();
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace(e));
            }
        });
        thread.start();
        return thread;
    }

    public static CommandScanner create() {
        return new CommandScanner();
    }
}

