/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.wrapper.api.server.route.routes.version.update;

import com.gamedash.daemon.wrapper.dependencies.common.api.server.request.Request;
import com.gamedash.daemon.wrapper.dependencies.common.api.server.response.Response;
import com.gamedash.daemon.wrapper.dependencies.common.api.server.route.Route;
import com.gamedash.daemon.wrapper.version.Version;
import com.gamedash.daemon.wrapper.version.Versions;
import com.gamedash.daemon.wrapper.version.installer.AlreadyUpdatingException;
import com.gamedash.daemon.wrapper.version.installer.Installer;

public class Update
extends Route<Void> {
    private final Request request;

    public Update(Request request, Response response) {
        super(request, response);
        this.request = request;
    }

    @Override
    public Void execute() throws Exception {
        if (Installer.isUpdating()) {
            throw new AlreadyUpdatingException("Already updating");
        }
        Version version = this.getVersion();
        Installer.update(version);
        return null;
    }

    private Version getVersion() throws Exception {
        if (this.getRequest().getInput().getParameters().exists("version_id")) {
            return Versions.get(this.request.getInput().getParameters().get("version_id").getValue());
        }
        return Versions.getLatest();
    }
}

