/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.wrapper.api.server.route;

import com.gamedash.daemon.wrapper.api.server.ApiServer;
import com.gamedash.daemon.wrapper.api.server.authentication.Authentication;
import com.gamedash.daemon.wrapper.api.server.route.routes.IsRunning;
import com.gamedash.daemon.wrapper.api.server.route.routes.Restart;
import com.gamedash.daemon.wrapper.api.server.route.routes.Root;
import com.gamedash.daemon.wrapper.api.server.route.routes.Shutdown;
import com.gamedash.daemon.wrapper.api.server.route.routes.Start;
import com.gamedash.daemon.wrapper.api.server.route.routes.authentication.SetToken;
import com.gamedash.daemon.wrapper.api.server.route.routes.process.childProcess.GetStatistics;
import com.gamedash.daemon.wrapper.api.server.route.routes.version.GetAvailable;
import com.gamedash.daemon.wrapper.api.server.route.routes.version.GetCurrent;
import com.gamedash.daemon.wrapper.api.server.route.routes.version.update.IsUpdating;
import com.gamedash.daemon.wrapper.api.server.route.routes.version.update.Update;
import com.gamedash.daemon.wrapper.dependencies.common.api.server.response.transformer.JsonResponseTransformer;
import com.gamedash.daemon.wrapper.dependencies.spark.ResponseTransformer;
import com.gamedash.daemon.wrapper.dependencies.spark.route.HttpMethod;

public class Routes {
    private final ApiServer apiServer;

    public Routes(ApiServer apiServer) {
        this.apiServer = apiServer;
    }

    public void register() {
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/", Root.class, (ResponseTransformer)new JsonResponseTransformer()).before((request, response) -> response.setType("application/json"));
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/process/childprocess/statistics", GetStatistics.class, (ResponseTransformer)new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/version/available", GetAvailable.class, (ResponseTransformer)new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/version/current", GetCurrent.class, (ResponseTransformer)new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.put, "/version/update/:version_id", Update.class, (ResponseTransformer)new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.put, "/version/update", Update.class, (ResponseTransformer)new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/version/update/isupdating", IsUpdating.class, (ResponseTransformer)new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.post, "/shutdown", Shutdown.class, (ResponseTransformer)new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.post, "/start", Start.class, (ResponseTransformer)new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.post, "/restart", Restart.class, (ResponseTransformer)new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.get, "/isrunning", IsRunning.class, (ResponseTransformer)new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
        this.apiServer.getRoutesManager().register(HttpMethod.put, "/authentication/token", SetToken.class, (ResponseTransformer)new JsonResponseTransformer()).before((request, response) -> {
            Authentication.ensureAuthenticated(request, response);
            response.setType("application/json");
        });
    }
}

