/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.wrapper;

import com.gamedash.daemon.wrapper.Args;
import com.gamedash.daemon.wrapper.commands.Commands;
import com.gamedash.daemon.wrapper.dependencies.common.api.client.response.logger.QueryResponseLogger;
import com.gamedash.daemon.wrapper.dependencies.common.authentication.Authentication;
import com.gamedash.daemon.wrapper.dependencies.common.authentication.AuthenticationResult;
import com.gamedash.daemon.wrapper.dependencies.common.development.DevelopmentMode;
import com.gamedash.daemon.wrapper.dependencies.common.installer.Installer;
import com.gamedash.daemon.wrapper.dependencies.org.apache.commons.lang3.exception.ExceptionUtils;
import com.gamedash.daemon.wrapper.initialization.implementations.ConfigInitializer;
import com.gamedash.daemon.wrapper.initialization.implementations.FileSystemInitializer;
import com.gamedash.daemon.wrapper.initialization.implementations.services.ServicesInitializer;
import com.gamedash.daemon.wrapper.shutdown.ShutdownManager;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Application {
    public static final Logger logger = LoggerFactory.getLogger(Application.class);
    public static Args args;

    public void run() throws Exception {
        if (Application.args.dev.booleanValue()) {
            DevelopmentMode.setIsEnabled(true);
        }
        if (Application.args.logApiClient.booleanValue()) {
            this.initializeApiClientListener();
        }
        this.listenForDevelopmentMode();
        new FileSystemInitializer().initialize();
        new ConfigInitializer().initialize();
        if (!Application.isInstallOnly() && Installer.isInstalled()) {
            this.authenticate();
        }
        this.initializeServices();
        ShutdownManager.registerHook();
        Commands.registerDefault();
    }

    private void listenForDevelopmentMode() {
        DevelopmentMode.onStatusChange(status -> {
            ConsoleAppender consoleAppender = (ConsoleAppender)LogManager.getRootLogger().getAppender("STDOUT");
            consoleAppender.setThreshold(status ? Level.INFO : Level.DEBUG);
        });
    }

    private void initializeApiClientListener() {
        if (!QueryResponseLogger.isListening()) {
            QueryResponseLogger.listen();
        }
    }

    private void initializeServices() {
        try {
            ServicesInitializer servicesInitializer = new ServicesInitializer();
            if (servicesInitializer.isAvailable()) {
                servicesInitializer.initialize();
            }
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace(e));
            System.exit(1);
        }
    }

    private void authenticate() throws Exception {
        AuthenticationResult result = Authentication.authenticate();
        if (!result.isValid()) {
            throw new RuntimeException(result.getMessage() != null ? result.getMessage() : "Could not authenticate");
        }
    }

    public static boolean isInstallOnly() {
        return Application.args.installOnly;
    }
}

