/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.windows.process;

import com.gamedash.daemon.windows.WindowsBridge;
import com.gamedash.daemon.windows.process.WindowsBridgeProcess;
import com.gamedash.daemon.windows.process.WindowsBridgeProcessException;
import com.gamedash.daemon.windows.result.WindowsBridgeResult;
import com.gamedash.daemon.windows.result.WindowsBridgeResults;
import java.util.ArrayList;
import java.util.List;

public class WindowsBridgeProcesses {
    public static List<WindowsBridgeProcess> getAll() throws Exception {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().getAllProcesses());
        if (result.isError()) {
            throw new WindowsBridgeProcessException(result.getErrorMessage());
        }
        ArrayList<WindowsBridgeProcess> processes = new ArrayList<WindowsBridgeProcess>();
        for (String id : result.getResultValueAsList()) {
            processes.add(WindowsBridgeProcesses.get(Integer.parseInt(id)));
        }
        return processes;
    }

    public static WindowsBridgeProcess get(int id) {
        return new WindowsBridgeProcess(id);
    }

    public static boolean exists(int id) throws Exception {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().processExists(id));
        if (result.isError()) {
            throw new WindowsBridgeProcessException(result.getErrorMessage());
        }
        return result.getResultValueAsBoolean();
    }
}

