/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.process.platform.linux;

import com.gamedash.daemon.process.IProcess;
import com.gamedash.daemon.process.Processes;
import com.gamedash.daemon.process.platform.linux.LinuxProcess;
import com.gamedash.daemon.process.platform.linux.LinuxProcessDescendant;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class LinuxProcessDescendants {
    private LinuxProcess rootProcess;
    private List<LinuxProcessDescendant> descendants = new ArrayList<LinuxProcessDescendant>();

    public LinuxProcessDescendants(LinuxProcess rootProcess) {
        this.rootProcess = rootProcess;
    }

    private List<LinuxProcessDescendant> getAll() throws Exception {
        for (LinuxProcessDescendant descendant : this.getImmediate().getAll()) {
            this.add(descendant);
            if (descendant.isThread()) continue;
            List<LinuxProcessDescendant> descendants = LinuxProcessDescendants.find(descendant.getProcess());
            this.addAll(descendants);
        }
        return this.descendants;
    }

    public DescendantsStruct getImmediate() throws Exception {
        DescendantsStruct descendants = new DescendantsStruct();
        for (IProcess iProcess : Processes.getAll()) {
            try {
                LinuxProcessDescendant descendant;
                Map<String, String> procFile = ((LinuxProcess)iProcess).readProcStatusFile();
                if (procFile.get("PPid").equals("0") && procFile.get("Tgid").equals("0") || !procFile.get("PPid").equals(Long.toString(this.rootProcess.getId())) || descendants.exists(descendant = new LinuxProcessDescendant((LinuxProcess)iProcess, false))) continue;
                descendants.add(descendant);
            }
            catch (IOException procFile) {}
        }
        for (LinuxProcess linuxProcess : this.rootProcess.getThreads()) {
            LinuxProcessDescendant descendant = new LinuxProcessDescendant(linuxProcess, true);
            if (descendant.getProcess().equals(this.rootProcess) || descendants.exists(descendant)) continue;
            descendants.add(descendant);
        }
        return descendants;
    }

    private void add(LinuxProcessDescendant descendant) {
        this.descendants.add(descendant);
    }

    private boolean isAdded(LinuxProcessDescendant process) {
        return this.descendants.contains(process);
    }

    private void addAll(List<LinuxProcessDescendant> processes) {
        for (LinuxProcessDescendant descendant : processes) {
            if (this.isAdded(descendant)) continue;
            this.add(descendant);
        }
    }

    public static List<LinuxProcessDescendant> find(LinuxProcess rootProcess) throws Exception {
        return new LinuxProcessDescendants(rootProcess).getAll();
    }

    public static class DescendantsStruct {
        private List<LinuxProcessDescendant> descendants = new ArrayList<LinuxProcessDescendant>();

        public List<LinuxProcessDescendant> getAll() {
            return this.descendants;
        }

        public void add(LinuxProcessDescendant descendant) {
            this.descendants.add(descendant);
        }

        public boolean exists(LinuxProcessDescendant descendant) {
            for (LinuxProcessDescendant _descendant : this.descendants) {
                if (!_descendant.equals(descendant)) continue;
                return true;
            }
            return false;
        }
    }
}

