/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.process.childProcess.terminal.windows;

import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.childProcess.terminal.ITerminal;
import com.gamedash.daemon.process.childProcess.terminal.io.IIo;
import com.gamedash.daemon.process.childProcess.terminal.windows.Io;
import com.gamedash.daemon.windows.process.childProcess.WindowsBridgeChildProcess;
import com.gamedash.daemon.windows.process.childProcess.WindowsBridgeChildProcessUser;
import com.gamedash.daemon.windows.process.childProcess.WindowsBridgeChildProcesses;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;

public class Windows
implements ITerminal {
    private ChildProcess childProcess;
    private WindowsBridgeChildProcess windowsChildProcess;
    private IIo io;

    public Windows(ChildProcess childProcess) throws IOException {
        this.childProcess = childProcess;
        this.io = new Io(this.childProcess);
    }

    @Override
    public void spawn(String[] inputArgs) throws Exception {
        String executable = inputArgs[0];
        String[] args = inputArgs.length > 1 ? Arrays.copyOfRange(inputArgs, 1, inputArgs.length) : new String[]{};
        this.windowsChildProcess = WindowsBridgeChildProcesses.create();
        if (this.childProcess.hasSystemUser()) {
            this.windowsChildProcess.setUser(new WindowsBridgeChildProcessUser(this.childProcess.getSystemUser()));
        }
        if (this.childProcess.hasWorkingDirectory().booleanValue()) {
            this.windowsChildProcess.setWorkingDirectory(this.childProcess.getWorkingDirectory());
        }
        this.getIo().listen();
        this.windowsChildProcess.spawn("C:\\Windows\\System32\\cmd.exe", ArrayUtils.addAll(new String[]{"/d", "/s", "/c", executable}, args));
    }

    @Override
    public void waitForExit() throws Exception {
        while (!this.hasExited()) {
            Thread.sleep(1000L);
        }
        return;
    }

    public boolean hasExited() throws Exception {
        return this.windowsChildProcess.hasExited();
    }

    @Override
    public void stop() throws Exception {
        this.getIo().destroy();
        this.windowsChildProcess.stop();
    }

    @Override
    public int getExitCode() {
        return this.windowsChildProcess.getExitCode();
    }

    @Override
    public boolean isRunning() throws Exception {
        return !this.windowsChildProcess.hasExited();
    }

    @Override
    public int getId() {
        return this.windowsChildProcess.getId();
    }

    @Override
    public IIo getIo() {
        return this.io;
    }

    @Override
    public <T> T getApi(Class<T> type) {
        return type.cast(this.windowsChildProcess);
    }
}

