/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.process.childProcess.resource.usage;

import com.gamedash.daemon.dependency.ProcessUsageDependency;
import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.childProcess.ChildProcesses;
import com.gamedash.daemon.process.childProcess.resource.usage.ResourceUsageResult;
import java.io.IOException;

public class ResourceUsage {
    private ChildProcess process;

    public ResourceUsage(ChildProcess process) {
        this.process = process;
    }

    public ResourceUsageResult query() throws Exception {
        ChildProcess childProcess = ChildProcesses.create();
        childProcess.spawn(ProcessUsageDependency.getFile().getPath(), new String[]{"pid=" + this.process.getId()});
        childProcess.waitForExit();
        if (childProcess.getExitCode() != 0) {
            throw new IOException("Query failed");
        }
        String result = childProcess.getIo().getOutputItems().get(0).getValue();
        String[] resultBits = result.split(",");
        return new ResourceUsageResult(Integer.parseInt(resultBits[0].replaceAll("[^0-9.]", "")), Integer.parseInt(resultBits[1].replaceAll("[^0-9.]", "")));
    }

    public static boolean isAvailable() {
        return true;
    }
}

