/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.process.childProcess;

import com.gamedash.daemon.common.listener.Listeners;
import com.gamedash.daemon.common.time.Time;
import com.gamedash.daemon.process.IProcess;
import com.gamedash.daemon.process.ProcessException;
import com.gamedash.daemon.process.Processes;
import com.gamedash.daemon.process.childProcess.ChildProcessException;
import com.gamedash.daemon.process.childProcess.ChildProcessIsTerminatingException;
import com.gamedash.daemon.process.childProcess.ChildProcessNotRunningException;
import com.gamedash.daemon.process.childProcess.ChildProcesses;
import com.gamedash.daemon.process.childProcess.crash.CrashManager;
import com.gamedash.daemon.process.childProcess.reference.References;
import com.gamedash.daemon.process.childProcess.resource.limit.ResourceLimits;
import com.gamedash.daemon.process.childProcess.resource.usage.ResourceUsage;
import com.gamedash.daemon.process.childProcess.terminal.IOnExit;
import com.gamedash.daemon.process.childProcess.terminal.Terminal;
import com.gamedash.daemon.process.childProcess.terminal.io.IIo;
import com.gamedash.daemon.shutdown.Shutdown;
import com.gamedash.daemon.system.user.SystemUser;
import com.gamedash.daemon.utilities.Os;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChildProcess {
    private static Logger logger = LoggerFactory.getLogger(ChildProcess.class);
    private Terminal terminal;
    private References references;
    private CrashManager crashManager;
    private ResourceUsage resourceUsage;
    private Listeners listeners = new Listeners();
    private File workingDirectory;
    private Map<String, String> environmentVariables = new HashMap<String, String>();
    private IProcess process;
    private SystemUser systemUser;
    private ResourceLimits resourceLimits;
    private boolean useShell = true;
    private boolean hasExited = false;
    private boolean isSelfManaged = true;
    private boolean isTerminating = false;
    private boolean shouldReportCrashes = false;
    private boolean canInterrupt = true;
    private Time timeCreated = Time.now();

    public ChildProcess(Class<?> terminalClass) throws Exception {
        this.terminal = new Terminal(this, terminalClass);
        this.references = new References(this);
        this.crashManager = new CrashManager(this);
        this.resourceUsage = new ResourceUsage(this);
        this.resourceLimits = new ResourceLimits(this);
        if (Os.isWindows()) {
            this.addEnvironmentVariable("PATH", System.getenv("path"));
        }
        if (Os.isUnix() && System.getenv("LD_LIBRARY_PATH") != null) {
            this.addEnvironmentVariable("LD_LIBRARY_PATH", System.getenv("LD_LIBRARY_PATH"));
        }
    }

    public void spawn(String executable) throws Exception {
        this.spawn(executable, new String[0]);
    }

    public void spawn(String executable, String[] args) throws Exception {
        ArrayList<Object> spawnArgs = new ArrayList<Object>();
        if (Os.isUnix()) {
            if (this.isUsingShell()) {
                if (this.hasSystemUser()) {
                    spawnArgs.add("sudo");
                    spawnArgs.add("-S");
                    spawnArgs.add("-u");
                    spawnArgs.add(this.systemUser.getName());
                }
                spawnArgs.add("/bin/sh");
                spawnArgs.add("-c");
                spawnArgs.add(executable + " " + String.join((CharSequence)" ", args));
            } else {
                if (this.hasSystemUser()) {
                    String[] systemUser = this.getSystemUser();
                    spawnArgs.add("sudo");
                    spawnArgs.add("-S");
                    spawnArgs.add("-u");
                    spawnArgs.add(systemUser.getName());
                }
                spawnArgs.add(executable);
                for (String arg : args) {
                    spawnArgs.add(arg);
                }
            }
        } else {
            spawnArgs.add(executable);
            spawnArgs.addAll(Arrays.asList(args));
        }
        logger.info("Spawning child process " + Arrays.toString(spawnArgs.toArray()) + " with id " + this.getId());
        try {
            this.getTerminal().getInstance().spawn(spawnArgs.toArray(new String[0]));
            this.onExit(() -> {
                logger.info("Child process " + this.getId() + " has exited");
                ArrayList<Thread> threads = new ArrayList<Thread>();
                if (this.getReferences().has()) {
                    this.getReferences().removeAllLocal();
                }
                if (this.shouldReportCrashes() && !this.isTerminating() && !Shutdown.isShuttingDown()) {
                    Thread crashManagerThread = new Thread(() -> {
                        try {
                            this.crashManager.report();
                        }
                        catch (Exception e) {
                            logger.error(e.getMessage());
                        }
                    });
                    crashManagerThread.start();
                    threads.add(crashManagerThread);
                }
                if (this.isSelfManaged()) {
                    for (Thread thread : threads) {
                        thread.join();
                    }
                    this.delete();
                }
            });
        }
        catch (Exception exception) {
            this.getReferences().removeAllLocal();
            throw exception;
        }
        this.listenForExit();
    }

    public void stop() throws Exception {
        if (!this.canInterrupt()) {
            throw new ChildProcessException("Can not interrupt child process");
        }
        if (this.isTerminating()) {
            throw new ChildProcessIsTerminatingException("Process is currently terminating");
        }
        if (!this.isRunning()) {
            throw new ChildProcessNotRunningException("Process is already not running any more");
        }
        this.setIsTerminating(true);
        try {
            this.getTerminal().getInstance().stop();
            this.waitForExit();
        }
        catch (Exception exception) {
            this.setIsTerminating(false);
            throw exception;
        }
    }

    public void kill() throws Exception {
        if (!this.canInterrupt()) {
            throw new ChildProcessException("Can not interrupt child process");
        }
        this.stop();
    }

    public int getExitCode() throws Exception {
        return this.getTerminal().getInstance().getExitCode();
    }

    public boolean isUsingShell() {
        return this.useShell;
    }

    public void setUseShell(boolean useShell) {
        this.useShell = useShell;
    }

    public IProcess getProcess() throws Exception {
        if (this.process == null) {
            this.process = Processes.get(this.getId());
        }
        return this.process;
    }

    public List<IProcess> getChildren() throws Exception {
        return this.getProcess().getAllChildren();
    }

    public void delete() throws Exception {
        if (!ChildProcesses.exists(this.getId())) {
            throw new ProcessException("Process does not exist");
        }
        if (this.isRunning()) {
            throw new ProcessException("This child process is still running");
        }
        ChildProcesses.getAll().remove(this);
    }

    public void onExit(IOnExit callback) throws Exception {
        this.listeners.get("onExit").addCallback(() -> {
            try {
                callback.method();
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        });
    }

    public void waitForExit() throws Exception {
        this.getTerminal().getInstance().waitForExit();
    }

    public boolean isRunning() throws Exception {
        return this.getTerminal().getInstance().isRunning();
    }

    public boolean hasExited() {
        return this.hasExited;
    }

    private void setHasExited(boolean hasExited) {
        this.hasExited = hasExited;
    }

    public int getId() throws Exception {
        return this.getTerminal().getInstance().getId();
    }

    public IIo getIo() throws Exception {
        return this.getTerminal().getInstance().getIo();
    }

    public ResourceUsage getResourceUsage() {
        return this.resourceUsage;
    }

    public ResourceLimits getResourceLimits() {
        return this.resourceLimits;
    }

    public <T> T getApi(Class<T> type) throws Exception {
        return this.getTerminal().getInstance().getApi(type);
    }

    public Terminal getTerminal() {
        return this.terminal;
    }

    public References getReferences() {
        return this.references;
    }

    private void listenForExit() {
        new Thread(() -> {
            try {
                this.waitForExit();
                this.setHasExited(true);
                this.listeners.get("onExit").invoke();
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }).start();
    }

    public boolean isTerminating() {
        return this.isTerminating;
    }

    private void setIsTerminating(boolean isTerminating) {
        this.isTerminating = isTerminating;
    }

    public boolean shouldReportCrashes() {
        return this.shouldReportCrashes;
    }

    public void setShouldReportCrashes(boolean shouldReportCrashes) {
        this.shouldReportCrashes = shouldReportCrashes;
    }

    public boolean isSelfManaged() {
        return this.isSelfManaged;
    }

    public void setIsSelfManaged(boolean isSelfManaged) {
        this.isSelfManaged = isSelfManaged;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public Boolean hasWorkingDirectory() {
        return this.workingDirectory != null;
    }

    public void setWorkingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public void addEnvironmentVariable(String name, String value) {
        this.environmentVariables.put(name, value);
    }

    public void setEnvironmentVariables(Map<String, String> environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public SystemUser getSystemUser() {
        return this.systemUser;
    }

    public boolean hasSystemUser() {
        return this.systemUser != null;
    }

    public void setSystemUser(SystemUser systemUser) {
        this.systemUser = systemUser;
    }

    public boolean canInterrupt() {
        return this.canInterrupt;
    }

    public void setCanInterrupt(boolean canInterrupt) {
        this.canInterrupt = canInterrupt;
    }

    public Time getTimeCreated() {
        return this.timeCreated;
    }
}

