/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.fileSystem.file.fileDownloader;

import com.gamedash.daemon.fileSystem.file.fileDownloader.FileDownloaderException;
import com.gamedash.daemon.fileSystem.file.fileDownloader.IFileDownloaderOnProgress;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class FileDownloader {
    private File file;
    private URL url;
    private List<IFileDownloaderOnProgress> onDownloadProgressCallbacks = new ArrayList<IFileDownloaderOnProgress>();

    public FileDownloader(File file, URL url) {
        this.file = file;
        this.url = url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download() throws Exception {
        if (this.file.exists() && this.file.isDirectory()) {
            throw new FileDownloaderException("File is a directory");
        }
        if (!this.file.getParentFile().exists()) {
            this.file.getParentFile().mkdirs();
        }
        HttpURLConnection httpConnection = (HttpURLConnection)this.url.openConnection();
        if (this.url.getProtocol().equals("https")) {
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)httpConnection;
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            httpsURLConnection.setSSLSocketFactory(sc.getSocketFactory());
            httpsURLConnection.setHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
        }
        httpConnection.connect();
        if (httpConnection.getResponseCode() != 200) {
            throw new FileDownloaderException("Server responded with status code " + httpConnection.getResponseCode() + " when attempting to download " + this.url.toString());
        }
        long totalSize = httpConnection.getContentLengthLong();
        int bufferSize = 1024;
        BufferedInputStream inputStream = new BufferedInputStream(httpConnection.getInputStream());
        BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(this.file));
        try {
            int length;
            byte[] buffer = new byte[bufferSize];
            long downloadedSize = 0L;
            while ((length = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, length);
                double percentage = (double)(downloadedSize += (long)length) / (double)totalSize * 100.0;
                this.onDownloadProgressCallbacks.forEach(callback -> callback.method(percentage));
            }
        }
        finally {
            inputStream.close();
            outputStream.close();
        }
    }

    public void onDownloadProgress(IFileDownloaderOnProgress callback) {
        this.onDownloadProgressCallbacks.add(callback);
    }
}

