/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.dependency;

import com.gamedash.daemon.dependency.DependencyAnnotation;
import com.gamedash.daemon.dependency.IDependency;
import com.gamedash.daemon.fileSystem.file.fileDownloader.FileDownloader;
import com.gamedash.daemon.system.OperatingSystem;
import com.gamedash.daemon.system.OperatingSystemArchitectureEnum;
import com.gamedash.daemon.windows.WindowsBridge;
import java.io.File;
import java.net.URL;
import org.apache.commons.lang3.SystemUtils;

@DependencyAnnotation(name="WindowsBridge32")
public class WindowsBridgeDependency32
implements IDependency {
    @Override
    public void install() throws Exception {
        FileDownloader fileDownloader = new FileDownloader(this.getFile(), new URL("https://download.gamedash.io/daemon/dependency/versions/1/WindowsBridge-x86.dll"));
        fileDownloader.download();
    }

    @Override
    public void uninstall() {
        this.getFile().delete();
    }

    @Override
    public boolean isAvailable() {
        return SystemUtils.IS_OS_WINDOWS && OperatingSystem.getArchitecture() == OperatingSystemArchitectureEnum.x86;
    }

    private File getFile() {
        return WindowsBridge.getDllFile();
    }
}

