/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.fileSystem.file.group;

import com.gamedash.daemon.api.server.route.Route;
import java.io.File;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.TrueFileFilter;
import spark.Request;
import spark.Response;

public class GetSize
extends Route<Long> {
    public GetSize(Request request, Response response) {
        super(request, response);
    }

    @Override
    public Long execute() throws Exception {
        List<String> filePaths = this.getParameters().get("files").getList();
        long totalSize = 0L;
        for (String filePath : filePaths) {
            com.gamedash.daemon.fileSystem.file.File file = com.gamedash.daemon.fileSystem.file.File.fromBase64(filePath);
            if (!file.exists()) continue;
            if (file.isDirectory()) {
                totalSize += this.getDirectorySize(file).longValue();
                continue;
            }
            totalSize += file.length();
        }
        return totalSize;
    }

    private Long getDirectorySize(com.gamedash.daemon.fileSystem.file.File directory) {
        long totalSize = 0L;
        List files = (List)FileUtils.listFilesAndDirs(directory, TrueFileFilter.INSTANCE, TrueFileFilter.INSTANCE);
        for (File file : files) {
            if (!file.isFile()) continue;
            totalSize += file.length();
        }
        return totalSize;
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"files", "directory"};
    }
}

