/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.relay.server.client;

import com.corundumstudio.socketio.SocketIOClient;
import com.gamedash.daemon.relay.client.ClientException;
import com.gamedash.daemon.relay.server.RelayServerException;
import com.gamedash.daemon.relay.server.client.Client;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;

public class Clients {
    private static List<Client> clients = new CopyOnWriteArrayList<Client>();

    public static List<Client> getAll() {
        return clients;
    }

    public static Client create(SocketIOClient socketIOClient) {
        if (Clients.exists(socketIOClient.getSessionId())) {
            throw new ClientException("Client " + socketIOClient.getSessionId().toString() + " already exists");
        }
        Client client = new Client(socketIOClient);
        clients.add(client);
        return client;
    }

    public static boolean exists(UUID id) {
        for (Client client : Clients.getAll()) {
            if (client.getId().compareTo(id) != 0) continue;
            return true;
        }
        return false;
    }

    public static Client get(UUID id) {
        for (Client client : Clients.getAll()) {
            if (client.getId().compareTo(id) != 0) continue;
            return client;
        }
        throw new RelayServerException("Client does not exist");
    }
}

