/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.relay.server.client;

import com.corundumstudio.socketio.SocketIOClient;
import com.gamedash.daemon.relay.Message;
import com.gamedash.daemon.relay.client.ClientException;
import com.gamedash.daemon.relay.server.channel.Channel;
import com.gamedash.daemon.relay.server.client.Channels;
import com.gamedash.daemon.relay.server.client.Clients;
import java.net.SocketAddress;
import java.util.UUID;

public class Client {
    private SocketIOClient socketIOClient;

    public Client(SocketIOClient socketIOClient) {
        this.socketIOClient = socketIOClient;
    }

    public UUID getId() {
        return this.socketIOClient.getSessionId();
    }

    public Channels getChannels() {
        return new Channels(this);
    }

    public void delete() {
        if (!Clients.exists(this.getId())) {
            throw new ClientException("Client does not exist");
        }
        if (this.socketIOClient.isChannelOpen()) {
            this.socketIOClient.disconnect();
        }
        Clients.getAll().remove(this);
        for (Channel channel : this.getChannels().getAll()) {
            channel.getClients().remove(this);
        }
    }

    public SocketAddress getRemoteAddress() {
        return this.socketIOClient.getRemoteAddress();
    }

    public void sendEvent(String name, Object ... data) {
        this.socketIOClient.sendEvent(name, data);
    }

    public void sendMessage(Message message) {
        this.sendEvent("message", message);
    }
}

