/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.relay.client.channel;

import com.gamedash.daemon.common.api.client.ApiQuery;
import com.gamedash.daemon.common.authentication.Authentication;
import com.gamedash.daemon.relay.Message;
import com.gamedash.daemon.relay.host.Host;
import com.gamedash.daemon.relay.host.Hosts;
import com.gamedash.daemon.relay.server.channel.Channels;
import com.google.gson.Gson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Channel {
    private static Logger logger = LoggerFactory.getLogger(Channel.class);
    private String name;

    public Channel(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void broadcast(Message message) throws Exception {
        final Host host = Hosts.getCurrent();
        if (host.isSelf()) {
            if (!Channels.exists(this.getName())) {
                return;
            }
            com.gamedash.daemon.relay.server.channel.Channel channel = Channels.get(this.getName());
            channel.broadcast(message);
        } else {
            ApiQuery query = new ApiQuery("relay/host/broadcast"){

                @Override
                protected String getAddress() throws Exception {
                    return this.getProtocol() + "://" + host.getNetwork().getIp().getHostAddress() + ":" + host.getNetwork().getPort() + "/" + this.getEndpoint();
                }

                @Override
                protected Boolean isSecure() throws Exception {
                    return host.getNetwork().isSecure();
                }
            };
            query.getHeaders().create("x-daemon-token").setValue(Authentication.getCurrentToken().toString());
            query.getParameters().create("channel", String.class).setValue(this.getName());
            query.getParameters().create("type", String.class).setValue(message.getType());
            query.getParameters().create("message", String.class).setValue(new Gson().toJson(message.getMessage()));
            query.post();
        }
    }
}

