/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.process.platform.windows;

import com.gamedash.daemon.process.IProcess;
import com.gamedash.daemon.process.ProcessPriorityEnum;
import com.gamedash.daemon.windows.process.WindowsBridgeProcess;
import com.gamedash.daemon.windows.process.WindowsBridgeProcessPriorityEnum;
import com.gamedash.daemon.windows.process.WindowsBridgeProcesses;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

public class WindowsProcess
implements IProcess {
    private int id;
    private WindowsBridgeProcess api;

    public WindowsProcess(int id) {
        this.id = id;
        this.api = WindowsBridgeProcesses.get(id);
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getName() throws Exception {
        return this.api.getName();
    }

    @Override
    public String[] getCommandLine() throws Exception {
        String[] cmdLine = new String[]{this.getFileName()};
        return ArrayUtils.addAll(cmdLine, this.getArguments());
    }

    public String getFileName() throws Exception {
        return this.api.getFileName();
    }

    public String[] getArguments() throws Exception {
        return this.api.getArguments();
    }

    @Override
    public File getWorkingDirectory() throws Exception {
        return this.api.getWorkingDirectory();
    }

    @Override
    public List<IProcess> getAllChildren() throws Exception {
        ArrayList<IProcess> processes = new ArrayList<IProcess>();
        for (WindowsBridgeProcess process : this.api.getChildren()) {
            processes.add(new WindowsProcess(process.getId()));
        }
        return processes;
    }

    @Override
    public void kill() throws Exception {
        this.api.kill();
    }

    @Override
    public void kill(String signal) throws Exception {
        this.api.kill();
    }

    @Override
    public void stop() throws Exception {
        this.api.kill();
    }

    @Override
    public ProcessPriorityEnum getPriority() throws Exception {
        WindowsBridgeProcessPriorityEnum windowsBridgePriority = this.api.getPriority();
        if (windowsBridgePriority == WindowsBridgeProcessPriorityEnum.idle || windowsBridgePriority == WindowsBridgeProcessPriorityEnum.low) {
            return ProcessPriorityEnum.low;
        }
        if (windowsBridgePriority == WindowsBridgeProcessPriorityEnum.normal || windowsBridgePriority == WindowsBridgeProcessPriorityEnum.aboveNormal) {
            return ProcessPriorityEnum.normal;
        }
        if (windowsBridgePriority == WindowsBridgeProcessPriorityEnum.high) {
            return ProcessPriorityEnum.high;
        }
        if (windowsBridgePriority == WindowsBridgeProcessPriorityEnum.realTime) {
            return ProcessPriorityEnum.realTime;
        }
        return ProcessPriorityEnum.normal;
    }

    @Override
    public void setPriority(ProcessPriorityEnum priority) throws Exception {
        WindowsBridgeProcessPriorityEnum windowsBridgeProcessPriorityEnum = WindowsBridgeProcessPriorityEnum.normal;
        if (priority == ProcessPriorityEnum.low) {
            windowsBridgeProcessPriorityEnum = WindowsBridgeProcessPriorityEnum.low;
        } else if (priority == ProcessPriorityEnum.normal) {
            windowsBridgeProcessPriorityEnum = WindowsBridgeProcessPriorityEnum.normal;
        } else if (priority == ProcessPriorityEnum.high) {
            windowsBridgeProcessPriorityEnum = WindowsBridgeProcessPriorityEnum.high;
        } else if (priority == ProcessPriorityEnum.realTime) {
            windowsBridgeProcessPriorityEnum = WindowsBridgeProcessPriorityEnum.realTime;
        }
        this.api.setPriority(windowsBridgeProcessPriorityEnum);
    }
}

