/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.process.childProcess.terminal.windows;

import com.gamedash.daemon.exception.NotImplementedException;
import com.gamedash.daemon.process.ProcessException;
import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.childProcess.terminal.io.IIo;
import com.gamedash.daemon.process.childProcess.terminal.io.IOnEventCallback;
import com.gamedash.daemon.process.childProcess.terminal.io.OutputHandler;
import com.gamedash.daemon.process.childProcess.terminal.io.OutputItem;
import com.gamedash.daemon.windows.process.childProcess.WindowsBridgeChildProcess;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Io
extends OutputHandler
implements IIo {
    private static Logger logger = LoggerFactory.getLogger(Io.class);
    private List<IOnEventCallback> onEventCallbacks = new CopyOnWriteArrayList<IOnEventCallback>();
    private boolean isListening = false;

    Io(ChildProcess childProcess) throws IOException {
        super(childProcess);
    }

    @Override
    public void write(String value) throws Exception {
        this.childProcess.getApi(WindowsBridgeChildProcess.class).sendInput(value);
    }

    @Override
    public void onOutputEvent(IOnEventCallback callback) {
        this.onEventCallbacks.add(callback);
    }

    private void invokeOnOutputEventCallbacks(OutputItem outputItem) {
        for (IOnEventCallback callback : this.onEventCallbacks) {
            callback.method(outputItem);
        }
    }

    @Override
    public void waitFor() throws Exception {
        throw new NotImplementedException();
    }

    @Override
    public void listen() {
        if (this.isListening) {
            throw new ProcessException("Already listening to io");
        }
        this.isListening = true;
        new Thread(() -> {
            try {
                this.childProcess.getApi(WindowsBridgeChildProcess.class).onOutput(windowsOutputItem -> {
                    OutputItem outputItem = new OutputItem(this.getCurrentIndex(), windowsOutputItem.getValue(), windowsOutputItem.isError());
                    this.addOutputItem(outputItem);
                    new Thread(() -> this.invokeOnOutputEventCallbacks(outputItem)).start();
                });
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }).start();
    }

    @Override
    public void destroy() throws Exception {
    }
}

