/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.process.childProcess.terminal.pty;

import com.gamedash.daemon.process.IProcess;
import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.childProcess.terminal.ITerminal;
import com.gamedash.daemon.process.childProcess.terminal.io.IIo;
import com.gamedash.daemon.process.childProcess.terminal.pty.Io;
import com.pty4j.PtyProcess;
import java.io.IOException;
import java.util.Map;

public class Pty
implements ITerminal {
    private ChildProcess childProcess;
    private PtyProcess api;
    private IIo io;

    public Pty(ChildProcess childProcess) throws IOException {
        this.childProcess = childProcess;
        this.io = new Io(this.childProcess);
    }

    @Override
    public void spawn(String[] args) throws Exception {
        Map<String, String> environmentVariables = this.childProcess.getEnvironmentVariables();
        this.api = PtyProcess.exec(args, environmentVariables, this.childProcess.hasWorkingDirectory() != false ? this.childProcess.getWorkingDirectory().toString() : null);
        this.getIo().listen();
    }

    @Override
    public void waitForExit() throws Exception {
        this.api.waitFor();
        this.io.waitFor();
    }

    @Override
    public void stop() throws Exception {
        this.getIo().destroy();
        for (IProcess child : this.childProcess.getChildren()) {
            child.kill();
        }
        this.api.destroy();
    }

    @Override
    public int getExitCode() {
        return this.api.exitValue();
    }

    @Override
    public boolean isRunning() {
        return this.api.isRunning();
    }

    @Override
    public int getId() {
        return this.api.getPid();
    }

    @Override
    public IIo getIo() {
        return this.io;
    }

    @Override
    public <T> T getApi(Class<T> type) {
        return type.cast(this.api);
    }
}

