/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.process.childProcess.io;

import com.gamedash.daemon.common.config.ConfigException;
import com.gamedash.daemon.config.Config;
import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.childProcess.terminal.ITerminal;
import com.gamedash.daemon.process.childProcess.terminal.io.IIo;
import com.gamedash.daemon.process.childProcess.terminal.io.IOnEventCallback;
import com.gamedash.daemon.process.childProcess.terminal.io.OutputItem;
import java.io.IOException;
import java.util.List;

public class Io {
    private ChildProcess childProcess;
    private ITerminal terminal;
    private IIo terminalIo;

    public Io(ChildProcess childProcess) throws Exception {
        this.childProcess = childProcess;
        this.terminal = this.childProcess.getTerminal().getInstance();
        this.terminalIo = this.terminal.getIo();
    }

    public void write(String value) throws Exception {
        this.terminalIo.write(value);
    }

    public void addOutput(OutputItem outputItem) {
        this.terminalIo.addOutputItem(outputItem);
    }

    public List<OutputItem> getOutput() {
        return this.terminalIo.getOutputItems();
    }

    public List<OutputItem> getOutput(int tail) {
        return this.terminalIo.getOutputItems(tail);
    }

    public void onOutputEvent(IOnEventCallback callback) {
        this.terminalIo.onOutputEvent(callback);
    }

    public void waitFor() throws Exception {
        this.terminalIo.waitFor();
    }

    public void listen() throws Exception {
        this.terminalIo.listen();
    }

    public static int getHistorySize() throws IOException, ConfigException {
        if (!Config.getFile("daemon.properties").valueExists("childProcess.terminal.io.output.history.size")) {
            return 250;
        }
        return Config.getFile("daemon.properties").getValue("childProcess.terminal.io.output.history.size", Integer.class);
    }
}

