/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.process.childProcess;

import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.childProcess.terminal.generic.Generic;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class ChildProcesses {
    private static List<ChildProcess> processes = new CopyOnWriteArrayList<ChildProcess>();

    public static List<ChildProcess> getAll() {
        return processes;
    }

    public static List<ChildProcess> getRunning() {
        ArrayList<ChildProcess> processes = new ArrayList<ChildProcess>();
        for (ChildProcess process : ChildProcesses.getAll()) {
            if (process.hasExited() || process.isTerminating()) continue;
            processes.add(process);
        }
        return processes;
    }

    public static void stopAll() throws Exception {
        for (ChildProcess childProcess : ChildProcesses.getAll()) {
            if (!childProcess.isRunning() || childProcess.isTerminating()) continue;
            childProcess.stop();
        }
    }

    public static ChildProcess create() throws Exception {
        return ChildProcesses.create(Generic.class);
    }

    public static ChildProcess create(Class<?> terminalClass) throws Exception {
        ChildProcess process = new ChildProcess(terminalClass);
        processes.add(process);
        return process;
    }

    public static ChildProcess get(int id) throws Exception {
        if (!ChildProcesses.exists(id)) {
            throw new Exception("Process with pid " + id + " does not exist");
        }
        for (ChildProcess process : ChildProcesses.getAll()) {
            if (process.getId() != id) continue;
            return process;
        }
        throw new Exception("Could not get childProcess");
    }

    public static boolean exists(int id) throws Exception {
        for (ChildProcess process : ChildProcesses.getAll()) {
            if (process.getId() != id) continue;
            return true;
        }
        return false;
    }
}

