/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.linux.cgroup.resource.cpu;

import com.gamedash.daemon.linux.cgroup.LinuxCGroup;
import com.gamedash.daemon.linux.cgroup.LinuxCGroupException;
import com.gamedash.daemon.linux.cgroup.controller.CPUController;
import com.gamedash.daemon.linux.cgroup.resource.Common;
import com.gamedash.daemon.linux.cgroup.resource.IResource;
import com.gamedash.daemon.process.IProcess;
import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.childProcess.ChildProcesses;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.SystemInfo;

public class CPUResource
extends Common
implements IResource {
    private static Logger logger = LoggerFactory.getLogger(CPUResource.class);
    private LinuxCGroup cGroup;
    private Integer percentage = null;

    public CPUResource(LinuxCGroup cGroup) {
        super(cGroup, new CPUController());
        this.cGroup = cGroup;
    }

    public Integer getPercentage() {
        return this.percentage;
    }

    public void setPercentage(int percentage) throws Exception {
        if (!this.isActive()) {
            this.create();
        }
        this.percentage = percentage;
        ChildProcess process = ChildProcesses.create();
        process.setCanInterrupt(false);
        process.spawn("cgset -r cpu.shares=" + this.getShares() + " " + this.cGroup.getName());
        logger.info("cgset -r cpu.shares=" + this.getShares() + " " + this.cGroup.getName());
        process.waitForExit();
        if (process.getExitCode() != 0) {
            throw new LinuxCGroupException("Could not set CPU shares");
        }
    }

    @Override
    public void limitProcess(IProcess processes) throws Exception {
        if (this.getPercentage() == null) {
            throw new LinuxCGroupException("No percentage is set");
        }
        this.classifyProcess(processes);
    }

    private int getShares() {
        return (int)Math.floor((float)this.getMaxShares() * ((float)this.getPercentage().intValue() / 100.0f));
    }

    public int getMaxShares() {
        return new SystemInfo().getHardware().getProcessor().getLogicalProcessors().length * 1024;
    }
}

