/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.linux.cgroup.resource;

import com.gamedash.daemon.linux.cgroup.LinuxCGroup;
import com.gamedash.daemon.linux.cgroup.LinuxCGroupException;
import com.gamedash.daemon.linux.cgroup.controller.IController;
import com.gamedash.daemon.linux.cgroup.resource.cpu.CPUResource;
import com.gamedash.daemon.process.IProcess;
import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.childProcess.ChildProcesses;
import com.gamedash.daemon.process.platform.linux.LinuxProcess;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Common {
    protected boolean isActive = false;
    private static Logger logger = LoggerFactory.getLogger(CPUResource.class);
    private LinuxCGroup cGroup;
    private IController controller;
    private List<ClassifiedProcess> classifiedProcesses = new CopyOnWriteArrayList<ClassifiedProcess>();
    private Thread watchdogThread;

    public Common(LinuxCGroup cGroup, IController controller) {
        this.cGroup = cGroup;
        this.controller = controller;
    }

    public void destroy() throws Exception {
        if (this.watchdogThreadIsRunning()) {
            this.watchdogThread.interrupt();
        }
        ChildProcess process = ChildProcesses.create();
        process.setCanInterrupt(false);
        process.spawn("cgdelete " + this.controller.getName() + ":/" + this.cGroup.getName());
        process.waitForExit();
    }

    protected void create() throws Exception {
        if (this.isActive()) {
            throw new LinuxCGroupException("CGroup has already been created");
        }
        this.setIsActive(true);
        ChildProcess process = ChildProcesses.create();
        process.setCanInterrupt(false);
        process.spawn("cgcreate -g " + this.controller.getName() + ":/" + this.cGroup.getName());
        process.waitForExit();
        if (process.getExitCode() != 0) {
            throw new LinuxCGroupException("Could not create cgroup");
        }
        logger.info("cgcreate -g " + this.controller.getName() + ":/" + this.cGroup.getName());
    }

    protected void classifyProcess(IProcess process) throws Exception {
        ChildProcess childProcess = ChildProcesses.create();
        childProcess.setCanInterrupt(false);
        ArrayList<Integer> ids = new ArrayList<Integer>();
        ids.add(process.getId());
        process.getAllChildren().forEach(child -> ids.add(child.getId()));
        childProcess.spawn("cgclassify -g " + this.controller.getName() + ":" + this.cGroup.getName() + " " + Joiner.on(' ').join(ids));
        childProcess.waitForExit();
        if (childProcess.getExitCode() != 0) {
            throw new LinuxCGroupException("Could not classify process");
        }
        if (this.processIsClassified(process)) {
            this.addClassifiedProcess(process);
        }
        if (!this.watchdogThreadIsRunning()) {
            this.startWatchdogThread();
        }
    }

    protected List<ClassifiedProcess> getClassifiedProcesses() {
        return this.classifiedProcesses;
    }

    protected boolean processIsClassified(IProcess process) {
        for (ClassifiedProcess classifiedProcess : this.getClassifiedProcesses()) {
            if (classifiedProcess.getId() != process.getId()) continue;
            return true;
        }
        return false;
    }

    protected void addClassifiedProcess(IProcess process) {
        this.classifiedProcesses.add(new ClassifiedProcess(process));
    }

    public boolean isActive() {
        return this.isActive;
    }

    protected void setIsActive(boolean isActive) {
        this.isActive = isActive;
    }

    private synchronized void startWatchdogThread() throws Exception {
        if (this.watchdogThreadIsRunning()) {
            throw new Exception("Already running thread");
        }
        this.watchdogThread = new Thread(() -> {
            try {
                block3: while (true) {
                    Thread.sleep(30000L);
                    Iterator<ClassifiedProcess> iterator = this.getClassifiedProcesses().iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block3;
                        ClassifiedProcess process = iterator.next();
                        this.classifyProcess(process);
                    }
                    break;
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        this.watchdogThread.start();
    }

    private boolean watchdogThreadIsRunning() {
        return this.watchdogThread != null && this.watchdogThread.isAlive();
    }

    private void stopWatchdogThread() {
        this.watchdogThread.interrupt();
        this.watchdogThread = null;
    }

    private static class ClassifiedProcess
    extends LinuxProcess {
        public ClassifiedProcess(IProcess process) {
            super(process.getId());
        }
    }
}

