/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.fileSystem.ftp.server.user;

import com.gamedash.daemon.common.config.ConfigException;
import com.gamedash.daemon.config.Config;
import com.gamedash.daemon.fileSystem.ftp.server.user.file.Files;
import com.gamedash.daemon.system.user.SystemUser;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.ftpserver.ftplet.Authority;
import org.apache.ftpserver.ftplet.AuthorizationRequest;
import org.apache.ftpserver.usermanager.impl.ConcurrentLoginPermission;

public class User
implements org.apache.ftpserver.ftplet.User {
    private String name;
    private String password;
    private File homeDirectory;
    private Files files;
    private List<Authority> authorities = new ArrayList<Authority>();
    private int maxIdleTime = 120;
    private int transferRate;
    private SystemUser systemUser;

    public User(String name, File homeDirectory) throws IOException, ConfigException {
        this.name = name;
        this.homeDirectory = homeDirectory;
        this.transferRate = Config.getFile("daemon.properties").valueExists("fileSystem.ftp.server.user.defaultTransferRate") ? Config.getFile("daemon.properties").getValue("fileSystem.ftp.server.user.defaultTransferRate", Integer.class) : 10000000;
        this.files = new Files(this);
        this.addAuthority(new ConcurrentLoginPermission(10, 10));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Files getFiles() {
        return this.files;
    }

    public List<Authority> getAuthorities() {
        return this.authorities;
    }

    public void addAuthority(Authority authority) {
        this.authorities.add(authority);
    }

    @Override
    public List<? extends Authority> getAuthorities(Class<? extends Authority> clazz) {
        ArrayList<Authority> selected = new ArrayList<Authority>();
        for (Authority authority : this.authorities) {
            if (!authority.getClass().equals(clazz)) continue;
            selected.add(authority);
        }
        return selected;
    }

    @Override
    public AuthorizationRequest authorize(AuthorizationRequest request) {
        if (this.authorities == null) {
            return null;
        }
        boolean someoneCouldAuthorize = false;
        for (Authority authority : this.authorities) {
            if (!authority.canAuthorize(request)) continue;
            someoneCouldAuthorize = true;
            if ((request = authority.authorize(request)) != null) continue;
            return null;
        }
        if (someoneCouldAuthorize) {
            return request;
        }
        return null;
    }

    @Override
    public int getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public void setMaxIdleTime(int maxIdleTime) {
        this.maxIdleTime = maxIdleTime;
    }

    public int getTransferRate() {
        return this.transferRate;
    }

    public void setTransferRate(int transferRate) {
        this.transferRate = transferRate;
    }

    @Override
    public boolean getEnabled() {
        return true;
    }

    @Override
    public String getHomeDirectory() {
        return this.homeDirectory.getPath();
    }

    public SystemUser getSystemUser() {
        return this.systemUser;
    }

    public void setSystemUser(SystemUser systemUser) {
        this.systemUser = systemUser;
    }

    public boolean hasSystemUser() {
        return this.systemUser != null;
    }
}

