/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.common.security.keyStore;

import com.gamedash.daemon.common.config.Config;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;

public class KeyStore {
    public static File getFile() throws IOException, KeyStoreException {
        if (!KeyStore.hasFile().booleanValue()) {
            throw new KeyStoreException("No keystore file is set");
        }
        return new File(Config.getFile("daemon.properties").getValue("security.keystore.file"));
    }

    public static Boolean hasFile() throws IOException {
        return Config.getFile("daemon.properties").valueExists("security.keystore.file");
    }

    public static void setFile(File file) throws IOException {
        Config.getFile("daemon.properties").setValue("security.keystore.file", file.getPath());
    }

    public static String getPassword() throws IOException, KeyStoreException {
        if (!KeyStore.hasPassword()) {
            throw new KeyStoreException("No keystore password is set");
        }
        return Config.getFile("daemon.properties").getValue("security.keystore.password");
    }

    public static boolean hasPassword() throws IOException {
        return Config.getFile("daemon.properties").valueExists("security.keystore.password");
    }

    public static void setPassword(String password) throws IOException {
        Config.getFile("daemon.properties").setValue("security.keystore.password", password);
    }

    public static boolean validatePassword(String password) throws IOException, SecurityException, KeyStoreException {
        return KeyStore.validatePassword(KeyStore.getFile(), password);
    }

    public static boolean validatePassword(File file, String password) throws IOException, SecurityException, KeyStoreException {
        java.security.KeyStore keyStore = java.security.KeyStore.getInstance(java.security.KeyStore.getDefaultType());
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            keyStore.load(fileInputStream, password.toCharArray());
        }
        catch (NoSuchAlgorithmException | CertificateException e) {
            return false;
        }
        return true;
    }

    public static Boolean isSelfSigned() throws Exception {
        return Config.getFile("daemon.properties").valueExists("security.keystore.isSelfSigned") && Config.getFile("daemon.properties").getValue("security.keystore.isSelfSigned", Boolean.class) != false;
    }

    public static void setIsSelfSigned(boolean isSelfSigned) throws IOException {
        Config.getFile("daemon.properties").setValue("security.keystore.isSelfSigned", isSelfSigned);
    }
}

