/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.common.license.system;

import com.gamedash.daemon.common.license.License;
import com.gamedash.daemon.common.license.api.client.LicenseApiClient;
import com.gamedash.daemon.common.license.api.client.LicenseApiClientQuery;
import com.gamedash.daemon.common.license.api.client.LicenseApiClientQueryResponse;
import com.gamedash.daemon.common.license.system.LicenseSystem;
import com.gamedash.daemon.common.license.system.LicenseSystemMaxExceededException;
import java.util.ArrayList;
import oshi.SystemInfo;
import oshi.hardware.NetworkIF;

public class LicenseSystems {
    private License license;

    public LicenseSystems(License license) {
        this.license = license;
    }

    public LicenseSystem get(String id) {
        return new LicenseSystem(this.license, id);
    }

    public LicenseSystem getCurrent() {
        return this.get(LicenseSystems.getId());
    }

    public boolean exists(String id) throws Exception {
        LicenseApiClientQuery query = LicenseApiClient.createQuery("license/system");
        query.getParameters().create("hash").setValue(this.license.getHash().toString());
        query.getParameters().create("id").setValue(id);
        query.setShouldHandleResponse(false);
        LicenseApiClientQueryResponse response = query.get();
        return response.getStatusCode() != 404;
    }

    public void create(String id) throws Exception {
        LicenseApiClientQuery query = LicenseApiClient.createQuery("license/system");
        query.getParameters().create("hash").setValue(this.license.getHash().toString());
        query.getParameters().create("id").setValue(id);
        query.setShouldHandleResponse(false);
        LicenseApiClientQueryResponse response = query.post();
        if (response.getStatusCode() != 200) {
            if (response.getJsonObject().get("error").getAsJsonObject().get("code").getAsString().equals("SYSTEM_MAX_EXCEEDED")) {
                throw new LicenseSystemMaxExceededException("System maximum exceeded");
            }
            throw new Exception(response.getJsonObject().get("error").getAsJsonObject().get("status").getAsString());
        }
    }

    private static String getId() {
        SystemInfo systemInfo = new SystemInfo();
        ArrayList<String> macAddresses = new ArrayList<String>();
        for (NetworkIF networkInterface : systemInfo.getHardware().getNetworkIFs()) {
            macAddresses.add(networkInterface.getMacaddr());
        }
        return (systemInfo.getHardware().getProcessor().getProcessorIdentifier().getProcessorID() + String.join((CharSequence)"", macAddresses)).replaceAll("/[^A-Za-z0-9:]/", "");
    }
}

