/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.common.api.client;

import com.gamedash.daemon.common.api.client.ApiClientConfigValidationResult;
import com.gamedash.daemon.common.config.Config;
import com.gamedash.daemon.common.config.ConfigException;
import java.io.IOException;

public class ApiClientConfig {
    public static boolean isSecure() throws IOException, ConfigException {
        if (!Config.getFile("daemon.properties").valueExists("api.client.security.enabled")) {
            return false;
        }
        return Config.getFile("daemon.properties").getValue("api.client.security.enabled", Boolean.class);
    }

    public static void setIsSecure(boolean isSecure) throws IOException, ConfigException {
        Config.getFile("daemon.properties").setValue("api.client.security.enabled", isSecure);
    }

    public static String getVersion() throws IOException, ConfigException {
        return Config.getFile("daemon.properties").getValue("api.client.version");
    }

    public static boolean hasVersion() throws IOException, ConfigException {
        return Config.getFile("daemon.properties").valueExists("api.client.version");
    }

    public static void setVersion(String version) throws IOException, ConfigException {
        Config.getFile("daemon.properties").setValue("api.client.version", version);
    }

    public static String getDomain() throws IOException, ConfigException {
        return Config.getFile("daemon.properties").getValue("api.client.domain");
    }

    public static boolean hasDomain() throws IOException, ConfigException {
        return Config.getFile("daemon.properties").valueExists("api.client.domain");
    }

    public static void setDomain(String domain) throws IOException, ConfigException {
        Config.getFile("daemon.properties").setValue("api.client.domain", domain);
    }

    public static ApiClientConfigValidationResult validate() throws IOException {
        if (!ApiClientConfig.hasVersion()) {
            return new ApiClientConfigValidationResult(false, "No version is set");
        }
        if (!ApiClientConfig.hasDomain()) {
            return new ApiClientConfigValidationResult(false, "No domain is set");
        }
        return new ApiClientConfigValidationResult(true);
    }
}

