/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.fileSystem.file.download;

import com.gamedash.daemon.api.server.route.Route;
import com.gamedash.daemon.fileSystem.file.File;
import com.gamedash.daemon.fileSystem.file.fileDownloader.FileDownloader;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.Base64;
import spark.Request;
import spark.Response;

public class Download
extends Route<String> {
    public Download(Request request, Response response) {
        super(request, response);
    }

    @Override
    public String execute() throws Exception {
        File destination = File.fromBase64(this.getParameters().get("destination").getValue());
        if (destination.exists() && !destination.isFile()) {
            throw new FileNotFoundException("Destination already exists, but is not a file");
        }
        URL url = new URL(new String(Base64.getDecoder().decode(this.getParameters().get("url").getValue())));
        FileDownloader fileDownloader = new FileDownloader(destination, url);
        fileDownloader.download();
        return null;
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"destination", "url"};
    }
}

