/*
 * Decompiled with CFR 0.152.
 */
package org.icmp4j.platform.linux;

import java.util.Iterator;
import java.util.List;
import org.icmp4j.IcmpPingRequest;
import org.icmp4j.IcmpPingResponse;
import org.icmp4j.IcmpPingUtil;
import org.icmp4j.platform.NativeBridge;
import org.icmp4j.util.ProcessUtil;
import org.icmp4j.util.StringUtil;

public class LinuxProcessNativeBridge
extends NativeBridge {
    @Override
    public IcmpPingResponse executePingRequest(IcmpPingRequest request) {
        try {
            boolean timeoutFlag;
            String host = request.getHost();
            int timeout = new Long(request.getTimeout()).intValue();
            int timeoutAsSeconds = timeout / 1000;
            int timeoutAsSeconds2 = timeoutAsSeconds > 0 ? timeoutAsSeconds : 1;
            int packetSize = request.getPacketSize();
            String command = "ping -c 1 -s " + packetSize + " -w " + timeoutAsSeconds2 + " " + host;
            long icmpSendEchoStartTime = System.currentTimeMillis();
            List<String> stringList = ProcessUtil.executeProcessAndGetOutputAsStringList(command);
            long icmpSendEchoDuration = System.currentTimeMillis() - icmpSendEchoStartTime;
            boolean bl = timeoutFlag = icmpSendEchoDuration >= (long)timeout;
            if (timeoutFlag) {
                return IcmpPingUtil.createTimeoutIcmpPingResponse(icmpSendEchoDuration);
            }
            return this.executePingRequest(stringList);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    IcmpPingResponse executePingRequest(List<String> stringList) {
        for (String string : stringList) {
            int icmpReqIndex = string.indexOf("icmp_req=");
            int icmpSeqIndex = string.indexOf("icmp_seq=");
            if (icmpReqIndex < 0 && icmpSeqIndex < 0) continue;
            int size = 0;
            int bytesIndex = string.indexOf(" bytes");
            if (bytesIndex > 0) {
                String sizeAsString = string.substring(0, bytesIndex);
                size = Integer.parseInt(sizeAsString);
            }
            String responseAddress = StringUtil.parseString(string, "from ", " ");
            String ttlAsString = StringUtil.parseString(string, "ttl=", " ");
            int ttl = Integer.parseInt(ttlAsString);
            String rttAsString = StringUtil.parseString(string, "time=", "ms");
            String rttAsString2 = rttAsString.trim();
            Float rttAsFloat = Float.valueOf(Float.parseFloat(rttAsString2));
            int rtt = rttAsFloat.intValue();
            IcmpPingResponse response = new IcmpPingResponse();
            response.setHost(responseAddress);
            response.setErrorMessage(null);
            response.setRtt(rtt);
            response.setSize(size);
            response.setSuccessFlag(true);
            response.setTtl(ttl);
            return response;
        }
        Iterator<String> iterator = stringList.iterator();
        if (iterator.hasNext()) {
            String string;
            string = iterator.next();
            IcmpPingResponse response = new IcmpPingResponse();
            response.setErrorMessage(string);
            response.setSuccessFlag(false);
            return response;
        }
        IcmpPingResponse response = new IcmpPingResponse();
        response.setErrorMessage("No results could be parsed");
        response.setSuccessFlag(false);
        return response;
    }
}

