/*
 * Decompiled with CFR 0.152.
 */
package org.icmp4j.logger;

import java.util.HashMap;
import java.util.Map;
import org.icmp4j.logger.PrintStreamLogger;

public abstract class Logger {
    private static Class<? extends Logger> loggerClass;
    private static final Map<Object, Logger> categoryToLoggerMap;
    private Object category;

    public static void setLoggerClass(Class<? extends Logger> loggerClass) {
        Logger.loggerClass = loggerClass;
    }

    public void setCategory(Object category) {
        this.category = category;
    }

    public Object getCategory() {
        return this.category;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger getLogger(Object category) {
        Logger logger = categoryToLoggerMap.get(category);
        if (logger != null) {
            return logger;
        }
        Class<Logger> clazz = Logger.class;
        synchronized (Logger.class) {
            Logger logger2 = categoryToLoggerMap.get(category);
            if (logger2 != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return logger2;
            }
            try {
                logger2 = loggerClass != null ? loggerClass.newInstance() : new PrintStreamLogger(System.out);
            }
            catch (Exception e) {
                System.out.println("<FATAL> <>");
                e.printStackTrace();
                logger2 = new PrintStreamLogger(System.out);
            }
            logger2.setCategory(category);
            categoryToLoggerMap.put(category, logger2);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return Logger.getLogger(category);
        }
    }

    public void trace(Object object) {
        Throwable t = null;
        this.log(1, object, t);
    }

    public void trace(Object object, Throwable t) {
        this.log(1, object, t);
    }

    public void trace(Throwable t) {
        Object object = null;
        this.log(1, object, t);
    }

    public void debug(Object object) {
        Throwable t = null;
        this.log(2, object, t);
    }

    public void debug(Object object, Throwable t) {
        this.log(2, object, t);
    }

    public void debug(Throwable t) {
        Object object = null;
        this.log(2, object, t);
    }

    public void info(Object object) {
        Throwable t = null;
        this.log(3, object, t);
    }

    public void info(Throwable t) {
        Object object = null;
        this.log(3, object, t);
    }

    public void warn(Object object) {
        Throwable t = null;
        this.log(5, object, t);
    }

    public void warn(Object object, Throwable t) {
        this.log(5, object, t);
    }

    public void warn(Throwable t) {
        Object object = null;
        this.log(5, object, t);
    }

    public void error(Object object) {
        Throwable t = null;
        this.log(4, object, t);
    }

    public void error(Object object, Throwable t) {
        this.log(4, object, t);
    }

    public void error(Throwable t) {
        Object object = null;
        this.log(4, object, t);
    }

    public void fatal(Object object) {
        Throwable t = null;
        this.log(6, object, t);
    }

    public void fatal(Object object, Throwable t) {
        this.log(6, object, t);
    }

    public void fatal(Throwable t) {
        Object object = null;
        this.log(6, object, t);
    }

    protected void log(int logLevel, Object object, Throwable t) {
        this.log2(logLevel, object, t);
    }

    protected void log2(int logLevel, Object object, Throwable t) {
    }

    public abstract boolean isDebugEnabled();

    public abstract boolean isInfoEnabled();

    public abstract boolean isTraceEnabled();

    public static String getLogLevelText(int logLevel) {
        return logLevel == 6 ? "FATAL" : (logLevel == 4 ? "ERROR" : (logLevel == 5 ? "WARN" : (logLevel == 3 ? "INFO" : (logLevel == 2 ? "DEBUG" : (logLevel == 1 ? "TRACE" : String.valueOf(logLevel))))));
    }

    static {
        categoryToLoggerMap = new HashMap<Object, Logger>();
    }
}

