/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.windows.childProcess;

import com.gamedash.daemon.common.helpers.fileSystem.FileSystemHelpers;
import com.gamedash.daemon.windows.WindowsBridge;
import com.gamedash.daemon.windows.WindowsBridgeException;
import com.gamedash.daemon.windows.childProcess.IWindowsOnExitCallback;
import com.gamedash.daemon.windows.childProcess.IWindowsOnOutputCallback;
import com.gamedash.daemon.windows.childProcess.WindowsChildProcessException;
import com.gamedash.daemon.windows.childProcess.WindowsChildProcessUser;
import com.gamedash.daemon.windows.childProcess.WindowsChildProcesses;
import com.gamedash.daemon.windows.childProcess.WindowsOutputItem;
import com.gamedash.daemon.windows.result.WindowsBridgeResult;
import com.gamedash.daemon.windows.result.WindowsBridgeResults;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class WindowsChildProcess {
    private int id;
    private WindowsChildProcessUser user;
    private List<IWindowsOnOutputCallback> onOutputCallbacks = new ArrayList<IWindowsOnOutputCallback>();
    private List<IWindowsOnExitCallback> onExitCallbacks = new ArrayList<IWindowsOnExitCallback>();
    private Integer currentOutputCursor = null;
    private File workingDirectory = FileSystemHelpers.getOwnDirectory(WindowsChildProcess.class);
    private Thread outputListenerThread;

    public int getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void spawn(String executable, String[] args) throws WindowsChildProcessException {
        WindowsBridgeResult result;
        if (this.hasUser() && this.getUser().getSystemUser().hasStoredPassword()) {
            WindowsChildProcessUser user = this.getUser();
            result = WindowsBridgeResults.get(WindowsBridge.getInstance().spawnChildProcessAsUser(executable, String.join((CharSequence)" ", args), this.getWorkingDirectory().getPath(), user.getSystemUser().getName(), user.getSystemUser().getStoredPassword()));
        } else {
            result = WindowsBridgeResults.get(WindowsBridge.getInstance().spawnChildProcess(executable, String.join((CharSequence)" ", args), this.getWorkingDirectory().getPath()));
        }
        try {
            if (result.isError()) {
                throw new WindowsChildProcessException(result.getErrorMessage());
            }
            this.id = result.getResultValueAsInteger();
            this.outputListenerThread = new Thread(() -> {
                try {
                    this.listenForOutput();
                }
                catch (WindowsChildProcessException e) {
                    e.printStackTrace();
                }
            });
            this.outputListenerThread.start();
            new Thread(() -> {
                try {
                    this.listenForExit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }).start();
        }
        finally {
            result.delete();
        }
    }

    public void stop() throws WindowsChildProcessException {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().stopChildProcess(this.getId()));
        try {
            if (result.isError()) {
                throw new WindowsChildProcessException(result.getErrorMessage());
            }
        }
        finally {
            result.delete();
        }
    }

    public void kill() throws WindowsChildProcessException {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().killChildProcess(this.getId()));
        try {
            if (result.isError()) {
                throw new WindowsChildProcessException(result.getErrorMessage());
            }
        }
        finally {
            result.delete();
        }
    }

    public int getExitCode() {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().getChildProcessExitCode(this.getId()));
        return result.getResultValueAsInteger();
    }

    public void delete() throws WindowsChildProcessException {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().deleteChildProcess(this.getId()));
        try {
            if (result.isError()) {
                throw new WindowsChildProcessException(result.getErrorMessage());
            }
            WindowsChildProcesses.getAll().remove(this);
        }
        finally {
            result.delete();
        }
    }

    public void waitForExit() throws WindowsChildProcessException {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().waitForChildProcessExit(this.getId()));
        try {
            if (result.isError()) {
                throw new WindowsChildProcessException(result.getErrorMessage());
            }
            this.waitForOutput();
        }
        finally {
            result.delete();
        }
    }

    public void onOutput(IWindowsOnOutputCallback callback) {
        this.onOutputCallbacks.add(callback);
    }

    public void sendInput(String input) throws WindowsBridgeException {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().childProcessSendInput(this.getId(), input));
        try {
            if (result.isError()) {
                throw new WindowsBridgeException(result.getErrorMessage());
            }
        }
        finally {
            result.delete();
        }
    }

    public void onExit(IWindowsOnExitCallback callback) {
        this.onExitCallbacks.add(callback);
    }

    public WindowsChildProcessUser getUser() {
        return this.user;
    }

    public boolean hasUser() {
        return this.user != null;
    }

    public void setUser(WindowsChildProcessUser user) {
        this.user = user;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(File directory) {
        this.workingDirectory = directory;
    }

    public boolean hasExited() throws WindowsChildProcessException {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().childProcessHasExited(this.getId()));
        try {
            if (result.isError()) {
                throw new WindowsChildProcessException(result.getErrorMessage());
            }
            boolean bl = result.getResultValueAsBoolean();
            return bl;
        }
        finally {
            result.delete();
        }
    }

    private void listenForExit() throws WindowsChildProcessException {
        this.waitForExit();
        this.onExitCallbacks.forEach(IWindowsOnExitCallback::method);
        if (this.outputListenerThread != null && this.outputListenerThread.isAlive()) {
            this.outputListenerThread.interrupt();
        }
    }

    private void listenForOutput() throws WindowsChildProcessException {
        try {
            while (true) {
                int outputCount;
                if ((outputCount = this.getProcessOutputCount()) > 0 && (this.getCurrentOutputCursor() == null || outputCount - 1 > this.getCurrentOutputCursor())) {
                    ArrayList<String> newSerializedOutputItems = new ArrayList<String>();
                    int newLineCount = this.getCurrentOutputCursor() == null ? outputCount : outputCount - this.getCurrentOutputCursor();
                    for (int index = 0; index <= newLineCount - 1; ++index) {
                        int outputIndex = (this.getCurrentOutputCursor() == null ? 0 : this.getCurrentOutputCursor()) + index;
                        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().getChildProcessOutput(this.getId(), outputIndex));
                        if (result.isError()) {
                            throw new WindowsChildProcessException("Could not get output for index " + outputIndex + ": " + result.getErrorMessage());
                        }
                        newSerializedOutputItems.add(result.getResultValueAsString());
                    }
                    newSerializedOutputItems.forEach(item -> {
                        WindowsOutputItem outputItem = new WindowsOutputItem((String)item, false);
                        this.onOutputCallbacks.forEach(callback -> callback.method(outputItem));
                    });
                    this.setCurrentOutputPointer(outputCount - 1);
                }
                Thread.sleep(200L);
            }
        }
        catch (InterruptedException e) {
            return;
        }
    }

    private void waitForOutput() {
        try {
            while (!this.hasExited() || this.getCurrentOutputCursor() == null || this.getProcessOutputCount() - 1 != this.getCurrentOutputCursor()) {
                Thread.sleep(200L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int getProcessOutputCount() throws WindowsChildProcessException {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().getChildProcessOutputCount(this.getId()));
        try {
            if (result.isError()) {
                throw new WindowsChildProcessException(result.getErrorMessage());
            }
            int n = result.getResultValueAsInteger();
            return n;
        }
        finally {
            result.delete();
        }
    }

    private Integer getCurrentOutputCursor() {
        return this.currentOutputCursor;
    }

    private synchronized void setCurrentOutputPointer(Integer cursor) {
        this.currentOutputCursor = cursor;
    }
}

