/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.system.user.windows;

import com.gamedash.daemon.system.user.ISystemUser;
import com.gamedash.daemon.system.user.windows.WindowsSystemUserException;
import com.gamedash.daemon.windows.WindowsBridge;
import com.gamedash.daemon.windows.result.WindowsBridgeResult;
import com.gamedash.daemon.windows.result.WindowsBridgeResults;
import java.io.File;

public class WindowsSystemUser
implements ISystemUser {
    private String name;

    public WindowsSystemUser(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void delete() throws WindowsSystemUserException {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().deleteOperatingSystemUser(this.getName()));
        try {
            if (result.isError()) {
                throw new WindowsSystemUserException(result.getErrorMessage());
            }
        }
        finally {
            result.delete();
        }
    }

    @Override
    public void setPassword(String password) throws WindowsSystemUserException {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().setOperatingSystemUserPassword(this.getName(), password));
        try {
            if (result.isError()) {
                throw new WindowsSystemUserException(result.getErrorMessage());
            }
        }
        finally {
            result.delete();
        }
    }

    @Override
    public void assignPermissions(File directory) throws WindowsSystemUserException {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().assignOperatingSystemUserPermissions(this.getName(), directory.getPath()));
        try {
            if (result.isError()) {
                throw new WindowsSystemUserException(result.getErrorMessage());
            }
        }
        finally {
            result.delete();
        }
    }

    @Override
    public void setHomeDirectory(File directory) throws WindowsSystemUserException {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().setOperatingSystemUserHomeDirectory(this.getName(), directory.getPath()));
        try {
            if (result.isError()) {
                throw new WindowsSystemUserException(result.getErrorMessage());
            }
        }
        finally {
            result.delete();
        }
    }

    public static boolean exists(String name) throws WindowsSystemUserException {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().operatingSystemUserExists(name));
        try {
            if (result.isError()) {
                throw new WindowsSystemUserException(result.getErrorMessage());
            }
            boolean bl = result.getResultValueAsBoolean();
            return bl;
        }
        finally {
            result.delete();
        }
    }

    public static void create(String name, String password) throws WindowsSystemUserException {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().createOperatingSystemUser(name, password));
        try {
            if (result.isError()) {
                throw new WindowsSystemUserException(result.getErrorMessage());
            }
        }
        finally {
            result.delete();
        }
    }
}

