/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.system.user.linux;

import com.gamedash.daemon.process.childprocess.ChildProcess;
import com.gamedash.daemon.process.childprocess.ChildProcesses;
import com.gamedash.daemon.system.user.ISystemUser;
import java.io.File;

public class LinuxSystemUser
implements ISystemUser {
    private String name;

    public LinuxSystemUser(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void delete() throws Exception {
        this.killProcesses();
        ChildProcess childProcess = ChildProcesses.create();
        childProcess.spawn("deluser", new String[]{this.getName()});
        childProcess.waitForExit();
    }

    @Override
    public void setPassword(String password) throws Exception {
        ChildProcess childProcess = ChildProcesses.create();
        childProcess.spawn("bash", new String[]{"echo", "'" + this.getName() + ":" + password + "'", "|", "chpasswd"});
        childProcess.waitForExit();
    }

    @Override
    public void assignPermissions(File directory) throws Exception {
        ChildProcess childProcess = ChildProcesses.create();
        childProcess.spawn("chown", new String[]{"-R", this.getName(), directory.getPath()});
        childProcess.waitForExit();
    }

    @Override
    public void setHomeDirectory(File directory) throws Exception {
        ChildProcess childProcess = ChildProcesses.create();
        childProcess.spawn("usermod", new String[]{"-d", directory.getPath(), this.getName()});
        childProcess.waitForExit();
    }

    private void killProcesses() throws Exception {
        ChildProcess childProcess = ChildProcesses.create();
        childProcess.spawn("pkill", new String[]{"-u", this.getName()});
        childProcess.waitForExit();
    }

    public static boolean exists(String name) throws Exception {
        ChildProcess childProcess = ChildProcesses.create();
        childProcess.spawn("id", new String[]{name});
        childProcess.waitForExit();
        return childProcess.getIo().getOutputItems().get(0) != null && childProcess.getIo().getOutputItems().get(0).getValue().charAt(0) == 'u';
    }

    public static void create(String name, String password) throws Exception {
        ChildProcess childProcess = ChildProcesses.create();
        childProcess.spawn("useradd", new String[]{"-p", "$(openssl passwd -1 " + password + ")"});
        childProcess.waitForExit();
    }
}

