/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.relay.server.client;

import com.corundumstudio.socketio.SocketIOClient;
import com.gamedash.daemon.relay.client.ClientException;
import com.gamedash.daemon.relay.server.RelayServerException;
import com.gamedash.daemon.relay.server.client.Client;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;

public class Clients {
    private static List<Client> clients = new CopyOnWriteArrayList<Client>();

    public static List<Client> getAll() {
        return clients;
    }

    public static Client create(SocketIOClient socketIoClient) {
        if (Clients.exists(socketIoClient.getSessionId())) {
            throw new ClientException("Client already exists exist");
        }
        Client client = new Client(socketIoClient);
        clients.add(client);
        return client;
    }

    public static boolean exists(UUID id) {
        for (Client client : Clients.getAll()) {
            if (client.getId().compareTo(id) != 0) continue;
            return true;
        }
        return false;
    }

    public static Client get(UUID id) {
        if (!Clients.exists(id)) {
            throw new RelayServerException("Client " + id.toString() + " does not exist");
        }
        for (Client client : Clients.getAll()) {
            if (client.getId().compareTo(id) != 0) continue;
            return client;
        }
        throw new RelayServerException("Could not get client");
    }
}

