/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.process.type;

import com.gamedash.daemon.process.IProcess;
import com.gamedash.daemon.process.IProcessCpuLimiter;
import com.gamedash.daemon.process.Processes;
import com.gamedash.daemon.process.childprocess.ChildProcess;
import com.gamedash.daemon.process.childprocess.ChildProcesses;
import com.gamedash.daemon.process.type.CpuLimiter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LinuxProcess
implements IProcess {
    private long id;
    private CpuLimiter cpuLimiter;

    public LinuxProcess(long id) {
        this.id = id;
        this.cpuLimiter = new CpuLimiter(this);
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void kill() throws Exception {
        this.kill("SIGKILl");
    }

    @Override
    public void kill(String signal) throws Exception {
        ChildProcess childProcess = ChildProcesses.create();
        childProcess.setUseShell(false);
        childProcess.spawn("kill", new String[]{"-" + signal, Long.toString(this.getId())});
        childProcess.waitForExit();
    }

    @Override
    public void stop() throws Exception {
        ChildProcess childProcess = ChildProcesses.create();
        childProcess.spawn("kill", new String[]{"-s", "TERM", Long.toString(this.getId())});
        childProcess.waitForExit();
    }

    @Override
    public IProcessCpuLimiter getCpuLimiter() {
        return this.cpuLimiter;
    }

    @Override
    public List<IProcess> getChildren() throws Exception {
        IProcess child;
        ArrayList<IProcess> children = new ArrayList<IProcess>();
        if (!this.procStatusFileExists()) {
            return children;
        }
        IProcess currentParent = this;
        while ((child = currentParent.getChild()) != null) {
            children.add(child);
            currentParent = child;
        }
        return children;
    }

    @Override
    public IProcess getChild() throws Exception {
        if (!this.procStatusFileExists()) {
            return null;
        }
        try {
            for (IProcess process : Processes.getAll()) {
                Map<String, String> procFile = ((LinuxProcess)process).readProcStatusFile();
                if (procFile.get("PPid").equals("0") && procFile.get("Tgid").equals("0") || !procFile.get("PPid").equals(Long.toString(this.getId()))) continue;
                return process;
            }
        }
        catch (IOException e) {
            return null;
        }
        return null;
    }

    public Map<String, String> readProcStatusFile() throws IOException {
        List<String> lines = Files.readAllLines(Paths.get("/proc/" + this.getId() + "/status", new String[0]));
        HashMap<String, String> output = new HashMap<String, String>();
        for (String line : lines) {
            String[] lineBits = line.split(":", 2);
            output.put(lineBits[0], lineBits[1].split("\\s+", 2)[1]);
        }
        return output;
    }

    private boolean procStatusFileExists() throws IOException {
        return new File("/proc/" + this.getId() + "/status").exists();
    }
}

