/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.process.childprocess.terminal.windows;

import com.gamedash.daemon.process.childprocess.ChildProcess;
import com.gamedash.daemon.process.childprocess.terminal.ITerminal;
import com.gamedash.daemon.process.childprocess.terminal.io.IIo;
import com.gamedash.daemon.process.childprocess.terminal.windows.Io;
import com.gamedash.daemon.windows.childProcess.WindowsChildProcess;
import com.gamedash.daemon.windows.childProcess.WindowsChildProcessException;
import com.gamedash.daemon.windows.childProcess.WindowsChildProcessUser;
import com.gamedash.daemon.windows.childProcess.WindowsChildProcesses;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;

public class Windows
implements ITerminal {
    private ChildProcess childProcess;
    private WindowsChildProcess windowsChildProcess;
    private IIo io;

    public Windows(ChildProcess childProcess) throws IOException {
        this.childProcess = childProcess;
        this.io = new Io(this.childProcess);
    }

    @Override
    public void spawn(String[] inputArgs) throws Exception {
        String executable = inputArgs[0];
        String[] args = inputArgs.length > 1 ? Arrays.copyOfRange(inputArgs, 1, inputArgs.length) : new String[]{};
        this.windowsChildProcess = WindowsChildProcesses.create();
        if (this.childProcess.hasSystemUser()) {
            this.windowsChildProcess.setUser(new WindowsChildProcessUser(this.childProcess.getSystemUser()));
        }
        if (this.childProcess.hasWorkingDirectory().booleanValue()) {
            this.windowsChildProcess.setWorkingDirectory(this.childProcess.getWorkingDirectory());
        }
        this.getIo().listen();
        this.windowsChildProcess.spawn("C:\\Windows\\System32\\cmd.exe", ArrayUtils.addAll(new String[]{"/d", "/s", "/c", executable}, args));
    }

    @Override
    public void waitForExit() throws Exception {
        this.windowsChildProcess.waitForExit();
    }

    @Override
    public void stop() throws Exception {
        this.getIo().destroy();
        this.windowsChildProcess.stop();
    }

    @Override
    public int getExitCode() {
        return this.windowsChildProcess.getExitCode();
    }

    @Override
    public boolean isRunning() throws WindowsChildProcessException {
        return !this.windowsChildProcess.hasExited();
    }

    @Override
    public long getId() {
        return this.windowsChildProcess.getId();
    }

    @Override
    public IIo getIo() {
        return this.io;
    }

    @Override
    public <T> T getApi(Class<T> type) {
        return type.cast(this.windowsChildProcess);
    }
}

