/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.fileSystem.ftp.server.user;

import com.gamedash.daemon.common.api.client.ApiClient;
import com.gamedash.daemon.common.api.client.ApiQuery;
import com.gamedash.daemon.common.api.client.QueryResponse;
import com.gamedash.daemon.fileSystem.ftp.server.FtpServerException;
import com.gamedash.daemon.fileSystem.ftp.server.user.User;
import com.gamedash.daemon.fileSystem.ftp.server.user.authentication.Authentication;
import com.gamedash.daemon.fileSystem.ftp.server.user.authentication.Result;
import com.gamedash.daemon.fileSystem.ftp.server.user.authority.WritePermission;
import com.gamedash.daemon.system.user.SystemUser;
import com.gamedash.daemon.system.user.SystemUsers;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.ArrayList;
import org.apache.ftpserver.ftplet.AuthenticationFailedException;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.usermanager.UsernamePasswordAuthentication;
import org.apache.ftpserver.usermanager.impl.TransferRatePermission;

public class UserManager
implements org.apache.ftpserver.ftplet.UserManager {
    @Override
    public User getUserByName(String name) throws FtpException {
        try {
            ApiQuery apiQuery = ApiClient.createQuery("infrastructure/node/daemon/filesystem/ftp/user/" + name);
            apiQuery.setShouldHandleResponse(false);
            QueryResponse apiQueryResponse = apiQuery.get();
            if (apiQueryResponse.getStatusCode() != 200) {
                if (apiQueryResponse.getStatusCode() == 404) {
                    return null;
                }
                throw new FtpServerException(apiQueryResponse.getJsonObject().get("error").getAsJsonObject().get("status").getAsString());
            }
            JsonObject jsonResponseObject = apiQueryResponse.getJsonObject().get("response").getAsJsonObject();
            User user = new User(name, new File(jsonResponseObject.get("directory").getAsJsonObject().get("path").getAsString()));
            if (!jsonResponseObject.get("node").getAsJsonObject().get("user").getAsJsonObject().get("id").isJsonNull()) {
                String systemUserName = jsonResponseObject.get("node").getAsJsonObject().get("user").getAsJsonObject().get("id").getAsString();
                SystemUser systemUser = SystemUsers.get(systemUserName);
                user.setSystemUser(systemUser);
            }
            user.addAuthority(new WritePermission(user));
            user.addAuthority(new TransferRatePermission(user.getTransferRate(), user.getTransferRate()));
            JsonElement extensions = apiQueryResponse.getJsonObject().get("response").getAsJsonObject().get("file").getAsJsonObject().get("extension");
            JsonArray writeExtensionsJsonArray = extensions.getAsJsonObject().get("writeable").getAsJsonArray();
            ArrayList<String> writeableExtensions = new ArrayList<String>();
            for (int i = 0; i < writeExtensionsJsonArray.size(); ++i) {
                writeableExtensions.add(writeExtensionsJsonArray.get(i).getAsString());
            }
            user.getFiles().getExtensions().setWriteable(writeableExtensions);
            JsonArray readableExtensionsJsonArray = extensions.getAsJsonObject().get("readable").getAsJsonArray();
            ArrayList<String> readableExtensions = new ArrayList<String>();
            for (int i = 0; i < writeExtensionsJsonArray.size(); ++i) {
                readableExtensions.add(readableExtensionsJsonArray.get(i).getAsString());
            }
            user.getFiles().getExtensions().setReadable(readableExtensions);
            return user;
        }
        catch (Exception exception) {
            throw new FtpException(exception.getMessage());
        }
    }

    @Override
    public String[] getAllUserNames() throws FtpException {
        throw new FtpException("Not implemented");
    }

    @Override
    public void delete(String username) throws FtpException {
    }

    @Override
    public void save(org.apache.ftpserver.ftplet.User user) throws FtpException {
    }

    @Override
    public boolean doesExist(String name) throws FtpException {
        try {
            return UserManager.exists(name);
        }
        catch (Exception exception) {
            throw new FtpException(exception.getMessage());
        }
    }

    @Override
    public User authenticate(org.apache.ftpserver.ftplet.Authentication authentication) throws AuthenticationFailedException {
        try {
            if (authentication instanceof UsernamePasswordAuthentication) {
                String password;
                UsernamePasswordAuthentication usernamePasswordAuthentication = (UsernamePasswordAuthentication)authentication;
                String name = usernamePasswordAuthentication.getUsername();
                Result authenticationResult = Authentication.authenticate(name, password = usernamePasswordAuthentication.getPassword());
                if (!authenticationResult.isValid()) {
                    throw new AuthenticationFailedException("Invalid details");
                }
                return this.getUserByName(name);
            }
            throw new AuthenticationFailedException("Authentication failed");
        }
        catch (Exception exception) {
            throw new AuthenticationFailedException(exception.getMessage());
        }
    }

    @Override
    public String getAdminName() throws FtpException {
        return null;
    }

    @Override
    public boolean isAdmin(String username) throws FtpException {
        return false;
    }

    public static boolean exists(String name) throws Exception {
        ApiQuery query = ApiClient.createQuery("infrastructure/node/daemon/filesystem/ftp/user/" + name + "/exists");
        return query.get().getJsonObject().get("response").getAsBoolean();
    }
}

