/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.fileSystem.ftp.server.fileSystem;

import com.gamedash.daemon.fileSystem.File;
import com.gamedash.daemon.fileSystem.ftp.server.user.User;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.ftpserver.filesystem.nativefs.impl.NativeFtpFile;

public class FtpFile
extends NativeFtpFile {
    private final File file;
    private final User user;

    public FtpFile(String fileName, File file, User user) {
        super(fileName, file, user);
        this.file = file;
        this.user = user;
    }

    @Override
    public List<org.apache.ftpserver.ftplet.FtpFile> listFiles() {
        if (!this.file.isDirectory()) {
            return null;
        }
        File[] files = this.file.listFiles();
        if (files == null) {
            return null;
        }
        Arrays.sort(files, Comparator.comparing(java.io.File::getName));
        Object virtualFileStr = this.getAbsolutePath();
        if (((String)virtualFileStr).charAt(((String)virtualFileStr).length() - 1) != '/') {
            virtualFileStr = (String)virtualFileStr + "/";
        }
        FtpFile[] virtualFiles = new FtpFile[files.length];
        for (int i = 0; i < files.length; ++i) {
            File fileObj = files[i];
            if (!fileObj.isDirectory() && fileObj.getExtension() != null && !this.user.getFiles().getExtensions().getReadable().contains(fileObj.getExtension())) continue;
            String fileName = (String)virtualFileStr + fileObj.getName();
            virtualFiles[i] = new FtpFile(fileName, fileObj, this.user);
        }
        return Collections.unmodifiableList(Arrays.asList(virtualFiles));
    }
}

