/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.fileSystem.file;

import com.gamedash.daemon.fileSystem.file.IFileDownloaderOnProgress;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class FileDownloader {
    private File file;
    private URL url;
    private List<IFileDownloaderOnProgress> onDownloadProgressCallbacks = new ArrayList<IFileDownloaderOnProgress>();

    public FileDownloader(File file, URL url) {
        this.file = file;
        this.url = url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download() throws IOException {
        HttpURLConnection httpConnection = (HttpURLConnection)this.url.openConnection();
        httpConnection.connect();
        if (httpConnection.getResponseCode() != 200) {
            throw new IOException("Server responded with status code " + httpConnection.getResponseCode() + " when attempting to download " + this.url.toString());
        }
        long totalSize = httpConnection.getContentLengthLong();
        int bufferSize = 1024;
        BufferedInputStream inputStream = new BufferedInputStream(httpConnection.getInputStream());
        BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(this.file));
        try {
            int length;
            byte[] buffer = new byte[bufferSize];
            long downloadedSize = 0L;
            while ((length = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, length);
                double percentage = (double)(downloadedSize += (long)length) / (double)totalSize;
                this.onDownloadProgressCallbacks.forEach(callback -> callback.method(percentage));
            }
        }
        finally {
            inputStream.close();
            outputStream.close();
        }
    }

    public void onDownloadProgress(IFileDownloaderOnProgress callback) {
        this.onDownloadProgressCallbacks.add(callback);
    }
}

